/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.StateExtractor;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.utils.BU;

public class CommonBdStateExctractor
implements StateExtractor {
    private final BidirectionPort port;
    private final Logger log;

    public CommonBdStateExctractor(BidirectionPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("BidirectionPort is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.port = port;
        this.log = log;
    }

    @Override
    public PosPrinterState getState() throws IOException {
        int state = 0;
        int flags = 0;
        LinkedList<Byte> bts = new LinkedList<Byte>();
        int data = this.getStatusByOne((byte)1);
        bts.add((byte)data);
        this.log.debug((Object)("status 1=" + data));
        data = this.getStatusByOne((byte)2);
        bts.add((byte)data);
        this.log.debug((Object)("status 2=" + data));
        if ((data & 4) != 0) {
            state = 2;
        }
        if ((data & 0x40) != 0) {
            state = 1;
        }
        data = this.getStatusByOne((byte)3);
        bts.add((byte)data);
        this.log.debug((Object)("status 3=" + data));
        if ((data & 8) != 0) {
            state = 5;
        }
        if ((data & 0x20) != 0) {
            state = -6;
        }
        if ((data & 0x40) != 0) {
            state = 3;
        }
        data = this.getStatusByOne((byte)4);
        bts.add((byte)data);
        this.log.debug((Object)("status 4=" + data));
        if ((data & 0xC) != 0) {
            flags |= 1;
        }
        if ((data & 0x20) != 0) {
            state = 1;
        }
        if (state > 0) {
            this.log.error((Object)("status bytes: " + BU.toString(bts)));
        }
        return new PosPrinterState(state, flags);
    }

    private int getStatusByOne(byte n) throws IOException {
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            this.port.write(new byte[]{16, 4, n});
            res = this.port.readByte();
            if ((res | 0x6C) != 126) continue;
            return res;
        }
        throw new IOException("Wrong format. Byte number " + n + ", Answer " + Integer.toHexString(res));
    }
}

