/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos;

import java.io.IOException;
import java.util.LinkedList;
import ru.softlogic.hardware.pos.InfoExtractor;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.utils.BU;

public class CommonBdInfoExtractor
implements InfoExtractor {
    private final BidirectionPort port;

    public CommonBdInfoExtractor(BidirectionPort port) {
        this.port = port;
    }

    @Override
    public int getModelId() throws IOException {
        this.port.write(new byte[]{29, 73, 1});
        return this.port.readByte();
    }

    @Override
    public String getModel() throws IOException {
        this.port.write(new byte[]{29, 73, 67});
        return new String(this.getStrAnswer());
    }

    @Override
    public String getFirmware() throws IOException {
        this.port.setTimeout(400);
        this.port.write(new byte[]{29, 73, 65});
        return new String(this.getStrAnswer()).trim();
    }

    private byte[] getStrAnswer() throws IOException {
        for (int i = 0; i < 10; ++i) {
            if (this.port.readByte() != 95) continue;
            LinkedList<Byte> res = new LinkedList<Byte>();
            for (int j = 0; j < 40; ++j) {
                byte[] b = this.port.read(1);
                if (b[0] == 0) {
                    return BU.convert(res);
                }
                res.add(b[0]);
            }
        }
        throw new IOException("Wrong answer");
    }
}

