/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.io.utils.BU;

public class Cmd {
    public static final String CMD_CLEAR = "clear";
    public static final String CMD_SPAN = "span";
    public static final String CMD_FONT = "font";
    public static final String CMD_RESET = "reset";
    public static final String CMD_CUT = "cut";
    public static final String CMD_WIDTH = "width";
    public static final String CMD_LEFTMARGIN = "left";
    public static final String CMD_SCROLL = "scroll";
    public static final String CMD_EJECT = "eject";
    public static final String CMD_ENCODING = "encoding";
    public static final char ALIAS_WIDTH = 'w';
    public static final char ALIAS_LEFT_MARGIN = 'l';
    private final Map<String, byte[]> cmds = new HashMap<String, byte[]>();
    private final ResourceBundle common = ResourceBundle.getBundle(Cmd.class.getPackage().getName() + ".cmds");
    private final ResourceBundle specific;
    private final Map<String, String> aliaces = new HashMap<String, String>();
    private Map<String, byte[]> tags;
    private Logger log;

    public Cmd(String type, Logger log) {
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.specific = ResourceBundle.getBundle("ru.softlogic.hardware.pos." + type + ".cmds");
        System.out.println(">>ru.softlogic.hardware.pos." + type + ".cmds");
        System.out.println(">>" + this.specific.getKeys());
        this.log = log;
    }

    public Map<String, byte[]> getTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, byte[]>();
            Enumeration<String> keys = this.common.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith("tag.")) continue;
                String tag = key.substring(4);
                this.tags.put(tag, this.readTag(key));
            }
        }
        return this.tags;
    }

    public byte[] getCmd(String cmd) {
        byte[] res = this.cmds.get(cmd);
        if (res == null) {
            res = this.readCmd(cmd);
            this.cmds.put(cmd, res);
        }
        return res;
    }

    public byte[] getCmd(String cmd, int type) {
        this.log.debug((Object)("Cmd: " + cmd));
        String key = cmd + "." + type;
        byte[] res = this.cmds.get(key);
        if (res == null) {
            res = this.readCmd(key);
            this.cmds.put(key, res);
        }
        this.log.debug((Object)("    <<<" + BU.toString((byte[])res)));
        return res;
    }

    public byte[] getParamCmd(String cmd, int val) {
        int bL = val & 0xFF;
        int bH = val >> 8 & 0xFF;
        String res = this.readRawCmd("cmd." + cmd);
        res = res.replaceAll("bL", String.format("%02X", bL)).replaceAll("bH", String.format("%02X ", bH));
        return BU.convertFromHex((String)this.processAliaces(res));
    }

    public void setAlias(char alias, int value) {
        int bL = value & 0xFF;
        int bH = value >> 8 & 0xFF;
        this.aliaces.put(alias + "L", String.format("%02X", bL));
        this.aliaces.put(alias + "H", String.format("%02X", bH));
    }

    private byte[] readCmd(String cmd) {
        String key = "cmd." + cmd;
        this.log.info((Object)("Cmd, key:" + key + ", " + this.specific.containsKey(key)));
        if (this.specific.containsKey(key)) {
            return this.processCmd(this.specific.getString(key));
        }
        if (this.common.containsKey(key)) {
            return this.processCmd(this.common.getString(key));
        }
        return new byte[0];
    }

    private byte[] readTag(String tag) {
        if (this.specific.containsKey(tag)) {
            return this.processCmd(this.specific.getString(tag));
        }
        return this.processCmd(this.common.getString(tag));
    }

    private String readRawCmd(String cmd) {
        if (this.specific.containsKey(cmd)) {
            return this.specific.getString(cmd);
        }
        if (this.common.containsKey(cmd)) {
            return this.common.getString(cmd);
        }
        return "";
    }

    private byte[] processCmd(String val) {
        if (this.isByteArray(val)) {
            return BU.convertFromHex((String)val);
        }
        this.log.info((Object)("Process: " + val));
        String rs = "";
        for (String str : val.split(",")) {
            rs = this.isByteArray(str) ? rs + str : (this.isResource(str) ? rs + this.processAliaces(this.readRawCmd(str)) : rs + this.processAliaces(str));
            this.log.info((Object)("   >>" + rs));
        }
        if (rs.isEmpty() || this.isByteArray(rs)) {
            return BU.convertFromHex((String)rs);
        }
        this.log.error((Object)("Can't parse byte sequence: " + rs));
        return null;
    }

    private String processAliaces(String str) {
        String pStr = str;
        this.log.debug((Object)("Aliaces: " + str));
        for (Map.Entry<String, String> entry : this.aliaces.entrySet()) {
            if (!str.contains(entry.getKey())) continue;
            pStr = pStr.replace(entry.getKey(), entry.getValue());
        }
        this.log.debug((Object)("Res: " + str));
        return pStr;
    }

    private boolean isByteArray(String val) {
        return val.isEmpty() || val.matches("[a-fA-F0-9 ]+");
    }

    private boolean isResource(String val) {
        return val.matches("[a-z]+\\.[a-z]+");
    }
}

