/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.search;

import java.io.IOException;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.mod.gsm.driver.GenericModemApi;
import ru.softlogic.hardware.mod.gsm.driver.ModemHelper;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hdw.dev.modem.ModemException;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Searchable
extends BaseSearchable {
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        GenericModemApi api = new GenericModemApi(port, this.log);
        api.setTimeout(100);
        try {
            this.log.info((Object)"Reset modem");
            api.open();
            api.setTextMode();
            api.configure();
            api.cancel();
            api.reset();
            this.log.info((Object)"Done, get vendor");
            String vendor = api.getVendor();
            this.log.info((Object)("Vendor: " + vendor));
            if (ModemHelper.isUssdRequeryForSearch(vendor)) {
                this.log.info((Object)"Vendor is require additional ussd check");
                int operator = api.getOperatorId();
                String ussd = ModemHelper.getUssdRequest(operator, null);
                if (ussd != null) {
                    this.log.info((Object)"Check by executing ussd request");
                    api.executeUssd(ussd, ModemHelper.isPDURequire(vendor), 5000);
                    this.log.info((Object)"Modem port confirmed");
                }
            }
            DeviceDescription deviceDescription = null;
            return deviceDescription;
        }
        catch (IOException | ModemException ex) {
            throw new NotFoundException("Not found", ex);
        }
        finally {
            this.log.info((Object)"Close port");
            api.close();
            this.log.info((Object)"Port closed");
        }
    }

    public SerialParams[] getSearchParams(int priority) {
        if (priority == 0) {
            return new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
        }
        if (priority == 1) {
            return new SerialParams[]{new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None)};
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 60;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 3);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }
}

