/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.driver;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.mod.gsm.driver.AtCommandResult;
import ru.softlogic.hardware.mod.gsm.driver.Modem;
import ru.softlogic.hdw.dev.modem.ModemException;

public class ModemResult<T> {
    private final AtCommandResult result;
    private final T data;

    public ModemResult(AtCommandResult result) {
        this(result, null);
    }

    public ModemResult(AtCommandResult result, T data) {
        if (result == null) {
            throw new NullPointerException("AtCommandResult is null");
        }
        this.result = result;
        this.data = data;
    }

    public boolean isOk() {
        return Modem.ResultCode.Ok.equals((Object)this.result.getCode());
    }

    public ModemResult<T> log(Logger log) {
        log.info((Object)("cmd=" + this.result.getAtCommand() + ", res=" + (Object)((Object)this.result.getCode()) + (this.data != null ? ", data=" + this.data : "")));
        return this;
    }

    public ModemResult<T> logEx(Logger log) {
        log.info((Object)(this.result + ", data=" + this.data));
        return this;
    }

    public ModemResult<T> check() throws ModemException {
        if (!Modem.ResultCode.Ok.equals((Object)this.result.getCode())) {
            throw new ModemException("Wrong answer code " + (Object)((Object)this.result.getCode()));
        }
        return this;
    }

    public AtCommandResult getResult() {
        return this.result;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "ModemResult2{result=" + this.result + ", data=" + this.data + '}';
    }
}

