/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.driver;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ModemHelper {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(ModemHelper.class.getPackage().getName() + ".codes");

    public static String getUssdRequest(int operator, String name) {
        if (name != null) {
            try {
                return bundle.getString("operator." + operator + "." + name.toLowerCase() + ".ussd");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            return bundle.getString("operator." + operator + ".ussd");
        }
        catch (MissingResourceException ex1) {
            return null;
        }
    }

    public static String getPowerOffRequest(String vendor) {
        if (vendor == null) {
            return bundle.getString("vendor.unknown.watchdog");
        }
        try {
            return bundle.getString("vendor." + vendor.toLowerCase().trim().replace(" ", "_") + ".watchdog");
        }
        catch (MissingResourceException ex) {
            try {
                return bundle.getString("vendor.unknown.watchdog");
            }
            catch (MissingResourceException ex1) {
                return null;
            }
        }
    }

    public static boolean isPDURequire(String vendor) {
        if (vendor == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(bundle.getString("vendor." + vendor.toLowerCase() + ".ussd.pdu-require"));
        }
        catch (MissingResourceException ex) {
            return false;
        }
    }

    public static boolean isUssdRequeryForSearch(String vendor) {
        if (vendor == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(bundle.getString("vendor." + vendor.toLowerCase() + ".search.ussd-require"));
        }
        catch (MissingResourceException ex) {
            return false;
        }
    }

    public static boolean isUssdCheckNeeded(String vendor) {
        if (vendor == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(bundle.getString("vendor." + vendor.toLowerCase() + ".search.ussd"));
        }
        catch (MissingResourceException ex) {
            return false;
        }
    }

    public static String getUssdForNumber(int vendor) {
        try {
            return bundle.getString("vendor." + vendor + ".number");
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static String[] getMinusPrefixes() {
        try {
            return bundle.getString("balance.minus").split(":");
        }
        catch (MissingResourceException ex) {
            return new String[0];
        }
    }
}

