/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.mod.gsm.Connector;
import ru.softlogic.hardware.mod.gsm.GsmUtils;
import ru.softlogic.hardware.mod.gsm.driver.ModemHelper;
import ru.softlogic.hdw.dev.modem.Api;
import ru.softlogic.hdw.dev.modem.MemoryStore;
import ru.softlogic.hdw.dev.modem.MessageFormatException;
import ru.softlogic.hdw.dev.modem.ModemException;
import ru.softlogic.hdw.dev.modem.Registration;
import ru.softlogic.hdw.dev.modem.Sms;
import ru.softlogic.hdw.dev.modem.SmsBox;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class GenericModemApi
implements Api {
    private volatile int timeout = 2500;
    private Logger log;
    private Connector connector;

    public GenericModemApi(SerialPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.log = log;
        this.connector = new Connector(port, log);
    }

    public void open() throws IOException {
        this.connector.open();
    }

    public void close() {
        this.connector.close();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getVendor() throws ModemException {
        this.log.debug((Object)"Get vendor");
        List<String> res = this.connector.send("AT+CGMI", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.debug((Object)"Response is interpreted as OK");
            return res.get(0).trim().replace("\r", "").replace("\n", "");
        }
        this.log.debug((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public String getModel() throws ModemException {
        this.log.debug((Object)"Get model");
        List<String> res = this.connector.send("AT+CGMM", this.timeout);
        if (res.size() > 1 && "ok".equalsIgnoreCase(res.get(1))) {
            this.log.debug((Object)"Response is interpreted as OK");
            return res.get(0).trim().replace("\r", "").replace("\n", "");
        }
        this.log.debug((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public String getFirmware() throws ModemException {
        this.log.info((Object)"Get firmware version");
        List<String> res = this.connector.send("AT+CGMR", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return res.get(0).trim().replace("\r", "").replace("\n", "");
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public long getImei() throws ModemException {
        this.log.info((Object)"Get IMEI");
        List<String> res = this.connector.send("AT+CGSN", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return Long.parseLong(res.get(0).trim());
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public long getImsi() throws ModemException {
        this.log.info((Object)"Get IMSI");
        List<String> res = this.connector.send("AT+CIMI", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return Long.parseLong(res.get(0).trim());
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public boolean isPowerManagement() throws ModemException {
        this.log.info((Object)"Check power management");
        List<String> res = this.connector.send("AT+CFUN=?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public boolean rebootGprsModule(String cmd) throws ModemException {
        this.log.info((Object)("Power control of GPRS-module. Send " + cmd));
        List<String> res = this.connector.send(cmd, 1000);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public boolean enableErrorDesc(boolean enable) throws ModemException {
        this.log.info((Object)"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u043e\u0439 \u043e\u0448\u0438\u0431\u043e\u043a");
        List<String> res = this.connector.send("AT+CMEE=" + (enable ? (char)'1' : '0'), this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public int getActivity() throws ModemException {
        this.log.info((Object)"Get activity ");
        List<String> res = this.connector.send("AT+CPAS", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            String[] tmp;
            this.log.info((Object)"Response is interpreted as OK");
            String data = res.get(0);
            if (data.matches("\\+CPAS: [\\d]{1,2}") && (tmp = data.split(" ")).length == 2) {
                try {
                    return Integer.parseInt(tmp[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ModemException("Wrong answer");
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public void reset() throws ModemException {
        this.log.info((Object)"Reset");
        List<String> res = this.connector.send("ATZ", this.timeout);
        if (res.size() <= 0 || !res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as ERROR");
            throw new ModemException("Wrong answer");
        }
        this.log.info((Object)"Response is interpreted as OK");
    }

    public void setTextMode() throws ModemException {
        this.log.info((Object)"Set text mode");
        this.connector.send("+++", this.timeout, false);
    }

    public void configure() throws ModemException {
        this.log.info((Object)"Configure modem");
        this.connector.send("AT S7=45 S0=0 L1 V1 X4 &c1 E1 Q0", this.timeout, false);
    }

    public int getSignalLevel() throws ModemException {
        this.log.info((Object)"Check signal level");
        List<String> res = this.connector.send("AT+CSQ", this.timeout);
        this.log.debug(res);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            String[] tmp;
            String data = res.get(0).toLowerCase();
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + data));
            if (data.matches("\\+csq: [\\d]{1,2},[\\d]{1,2}") && (tmp = data.split(" ")).length == 2 && (tmp = tmp[1].split(",")).length == 2) {
                try {
                    int value = Integer.parseInt(tmp[0]);
                    return Math.min(value * 100 / 30, 100);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ModemException("Wrong answer");
        }
        this.log.debug((Object)"Error on read answer");
        throw new ModemException("Wrong answer");
    }

    public boolean dial(String number) throws ModemException {
        this.log.info((Object)("\u0417\u0432\u043e\u043d\u043e\u043a \u043d\u0430 \u043d\u043e\u043c\u0435\u0440 " + number));
        List<String> res = this.connector.send("ATD" + number + ";", 20000);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public boolean cancel() throws ModemException {
        this.log.info((Object)"Cancel");
        List<String> res = this.connector.send("ATH", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public String getOperatorName() throws ModemException {
        this.log.debug((Object)"Get operator name");
        List<String> res = this.connector.send("AT+COPS=3,0", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            res = this.connector.send("AT+COPS?", this.timeout);
            if (this.listContainsOk(res)) {
                String result = res.get(0);
                Pattern p = Pattern.compile("\\+COPS: [\\d],[\\d],\\\"(.*)\\\"");
                Matcher m2 = p.matcher(result);
                if (m2.find()) {
                    return m2.group(1);
                }
                throw new ModemException("Wrong answer");
            }
            this.log.debug((Object)"Error on read answer");
            throw new ModemException("Wrong answer");
        }
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u043a\u0430\u0437\u0430 \u0438\u043c\u0435\u043d\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
    }

    public int getOperatorId() throws ModemException {
        this.log.info((Object)"Get operator id");
        List<String> res = this.connector.send("AT+COPS=3,2", this.timeout);
        if (this.listContainsOk(res)) {
            res = this.connector.send("AT+COPS?", this.timeout);
            if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
                String result = res.get(0);
                Pattern p = Pattern.compile("\\+COPS: [\\d],[\\d],\"?([\\d]*)\"?");
                Matcher m2 = p.matcher(result);
                if (m2.find()) {
                    return Integer.parseInt(m2.group(1));
                }
                throw new ModemException("Wrong answer");
            }
            this.log.debug((Object)"Error on read answer");
            throw new ModemException("Wrong answer");
        }
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u043a\u0430\u0437\u0430 \u0438\u043c\u0435\u043d\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
    }

    public String executeUssd(String cmd, boolean pduRequire) throws ModemException {
        return this.executeUssd(cmd, pduRequire, 60000);
    }

    public String executeAtd(String cmd, boolean pduRequire) throws ModemException {
        return this.executeAtd(cmd, pduRequire, 60000);
    }

    public String executeAtd(String cmd, boolean pduRequire, int timeout) throws ModemException {
        this.log.info((Object)("Atd request: " + cmd));
        String request = pduRequire ? GsmUtils.encodePDU(cmd) : cmd;
        List<String> res = this.connector.sendUssd(request, '\r', timeout);
        if (this.listContainsOk(res)) {
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + res.get(0)));
            String result = res.get(1);
            result = result.replace("\r", "").replace("\n", "");
            if (!result.matches("\\+CUSD: \\d,\".*\".*")) {
                throw new ModemException("Wrong answer \u043d\u0430 USSD \u0437\u0430\u043f\u0440\u043e\u0441");
            }
            String message = result.substring(result.indexOf(34) + 1, result.lastIndexOf("\",") > 0 ? result.indexOf("\",") : result.length());
            try {
                result = pduRequire ? new String(GsmUtils.ucs2Encode(GsmUtils.decodePDUtoHex(message)), "UTF-16") : new String(GsmUtils.ucs2Encode(message), "UTF-16");
            }
            catch (UnsupportedEncodingException | NumberFormatException ex) {
                result = message;
            }
            this.log.debug((Object)("\u041e\u043a\u043e\u043d\u0447\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + result));
            return result;
        }
        this.log.debug((Object)"Error on read answer");
        return "undefined";
    }

    public String executeUssd(String cmd, boolean pduRequire, int timeout) throws ModemException {
        String USC2 = "72";
        this.log.info((Object)("USSD request: " + cmd));
        String request = pduRequire ? GsmUtils.encodePDU(cmd) : cmd;
        this.connector.send("at", 5000);
        List<String> res = null;
        try {
            res = this.connector.sendUssd("AT+CUSD=1,\"" + request + "\",15", '\r', timeout);
            if (res.size() < 1 || !this.listContainsOk(res) || res.get(1).equalsIgnoreCase("ERROR")) {
                throw new ModemException();
            }
        }
        catch (ModemException ex) {
            this.connector.send("AT+CUSD=2", timeout);
            res = this.connector.sendUssd("ATD" + cmd + ";", '\r', timeout);
        }
        if (this.listContainsOk(res)) {
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + res.get(0)));
            String result = res.get(1);
            result = result.replace("\r", "").replace("\n", "");
            if (!result.matches("(OK,)?\\+CUSD: \\d,\".*\".*")) {
                throw new ModemException("Wrong answer \u043d\u0430 USSD \u0437\u0430\u043f\u0440\u043e\u0441");
            }
            String message = result.substring(result.indexOf(34) + 1, result.lastIndexOf("\",") > 0 ? result.indexOf("\",") : result.length());
            try {
                if (result.endsWith("72")) {
                    return new String(BU.convertFromHex((String)message), "UTF-16");
                }
                return new String(GsmUtils.ucs2Encode(GsmUtils.decodePDUtoHex(message)), "UTF-16");
            }
            catch (UnsupportedEncodingException | NumberFormatException ex) {
                result = message;
                this.log.debug((Object)("\u041e\u043a\u043e\u043d\u0447\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + result));
                return result;
            }
        }
        this.log.debug((Object)"Error on read answer");
        return "undefined";
    }

    public boolean setRegistrationMode(int mode) throws ModemException {
        this.log.info((Object)("Set registration mode: " + mode));
        List<String> res = this.connector.send("AT+CREG=" + mode, this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public Registration getRegistration() throws ModemException {
        this.log.info((Object)"Request registration");
        List<String> res = this.connector.send("AT+CREG?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            String result = res.get(0);
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + result));
            if (result.matches("\\+CREG: (0|1|2),(0|1|2|3|4|5)(,.*{1,7})?(,.*{1,7})?")) {
                String[] tmp = result.replaceAll("\"", "").split(",");
                if (tmp.length == 2) {
                    return new Registration(Integer.parseInt(tmp[1]));
                }
                return new Registration(Integer.parseInt(tmp[1]), tmp[2], tmp[3]);
            }
        }
        this.log.debug((Object)"Error on read answer");
        throw new ModemException("Wrong answer");
    }

    public boolean transmitTones(String data) throws ModemException {
        this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u0435\u043c \u0442\u043e\u043d\u043e\u0432\u043e\u044e \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443");
        List<String> res = this.connector.send("AT+VTS=" + data, this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public boolean setToneDuration(int nsec) throws ModemException {
        this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043d\u0430\u0436\u0430\u0442\u0438\u044f \u043a\u043b\u0430\u0432\u0438\u0448");
        List<String> res = this.connector.send("AT+VTD=" + String.valueOf(nsec), this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public boolean smsMode(int mode) throws ModemException {
        this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0440\u0435\u0436\u0438\u043c SMS: " + mode));
        List<String> res = this.connector.send("AT+CMGF=" + mode, this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public MemoryStore[] smsStores() throws ModemException {
        String result;
        this.log.info((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u0438\u043c\u0435\u043d\u0430 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u044c sms");
        List<String> res = this.connector.send("AT+CPMS=?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok") && (result = res.get(0).trim()).startsWith("+CPMS: ")) {
            String[] mem = (result = result.substring(7)).split("\\),\\(");
            if (mem.length == 3) {
                LinkedList<MemoryStore> list = new LinkedList<MemoryStore>();
                Pattern p = Pattern.compile("([A-Z]+,?)");
                for (int i = 0; i < 3; ++i) {
                    Matcher m2 = p.matcher(mem[i]);
                    while (m2.find()) {
                        if (i == 0) {
                            list.add(new MemoryStore(m2.group(0), 0));
                            continue;
                        }
                        if (i == 1) {
                            list.add(new MemoryStore(m2.group(0), 1));
                            continue;
                        }
                        list.add(new MemoryStore(m2.group(0), 2));
                    }
                }
                return list.toArray(new MemoryStore[list.size()]);
            }
            this.log.error((Object)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0433\u0440\u0443\u043f\u043f \u043d\u0435 \u0440\u0430\u0432\u043d\u043e 3. \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public Map<String, SmsBox> smsCount() throws ModemException {
        String result;
        this.log.info((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e sms");
        List<String> res = this.connector.send("AT+CPMS?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok") && (result = res.get(0).trim()).startsWith("+CPMS: ")) {
            result = result.substring(7);
            Pattern p = Pattern.compile("(\"[A-Z]+\",\\d+,\\d+,?)");
            Pattern p2 = Pattern.compile("\"([A-Z]+)\",(\\d+),(\\d+),?");
            Matcher m2 = p.matcher(result);
            HashMap<String, SmsBox> map = new HashMap<String, SmsBox>();
            while (m2.find()) {
                Matcher m22 = p2.matcher(m2.group(0));
                while (m22.find()) {
                    try {
                        map.put(m22.group(1), new SmsBox(Integer.parseInt(m22.group(2)), Integer.parseInt(m22.group(3))));
                    }
                    catch (NumberFormatException ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0447\u0438\u0441\u043b\u0430, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u044e", (Throwable)ex);
                    }
                }
            }
            return map;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public boolean smsMem(String name) throws ModemException {
        this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0442\u0438\u043f \u043f\u0430\u043c\u044f\u0442\u0438 \u0434\u043b\u044f sms: " + name));
        List<String> res = this.connector.send("AT+CPMS=\"" + name + "\"", this.timeout);
        this.log.info((Object)("Result: " + res));
        if (res.size() > 1) {
            for (String field : res) {
                if (!field.equalsIgnoreCase("ok")) continue;
                this.log.info((Object)"Response is interpreted as OK");
                return true;
            }
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        throw new ModemException("Wrong answer");
    }

    public boolean smsClear() throws ModemException {
        this.log.info((Object)"\u0423\u0434\u0430\u043b\u044f\u0435\u043c \u0432\u0441\u0435 SMS \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        List<String> res = this.connector.send("AT+CNUM", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"Response is interpreted as OK");
            return true;
        }
        this.log.info((Object)"Response is interpreted as ERROR");
        return false;
    }

    public boolean smsSend(String phone, String message, int mode) throws MessageFormatException, ModemException {
        this.log.info((Object)"\u041e\u0442\u0441\u044b\u043b\u0430\u0435\u043c \u0441\u043c\u0441");
        if (!message.matches("[\\dA-Za-z\\.,;]{1,170}")) {
            throw new MessageFormatException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043d\u0435\u0432\u0435\u0440\u0435\u043d");
        }
        this.connector.send("AT+CMEE=2", 5000);
        this.connector.send("AT+CMGF=" + mode, 5000);
        this.connector.sendSms(phone, message, 10000);
        return true;
    }

    public List<Sms> readAllSms() throws ModemException {
        this.connector.send("AT+CMGF=1", 5000);
        List<String> send = this.connector.send("AT+CMGL=\"ALL\"", 5000);
        ArrayList<Sms> result = new ArrayList<Sms>(send.size());
        for (int i = 0; i < send.size() - 1; i += 2) {
            try {
                Sms sms = new Sms(send.get(i), send.get(i + 1));
                result.add(sms);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public Sms readSms(int index) throws ModemException {
        List<String> send = this.connector.send("AT+CMGR=" + index, 5000);
        if (send.size() == 3 && send.get(2).equalsIgnoreCase("OK")) {
            return new Sms(send.get(0), send.get(1));
        }
        return null;
    }

    public String getLastSms() throws ModemException {
        List<Sms> smsList = this.readAllSms();
        if (smsList != null && !smsList.isEmpty()) {
            return smsList.get(smsList.size() - 1).getText();
        }
        return null;
    }

    public String getPhoneNumber(String request, boolean isPdu, int smsTimeout) throws ModemException {
        this.connector.send("AT+CMEE=2", this.timeout);
        this.selectSmsStorage("SM");
        this.smsClear();
        String data = this.executeUssd(request, isPdu, 5000);
        this.log.info((Object)("data: " + data));
        String pattern = "(^.*(\\+?\\d{0,3}[9]{1}[0-9]{7,11}).*$)";
        if (data.matches(pattern)) {
            return data.replaceAll(pattern, "$2");
        }
        String lastSmsText = null;
        for (int attempts = 0; attempts < 20 && lastSmsText == null; ++attempts) {
            try {
                Thread.sleep(smsTimeout);
                lastSmsText = this.getLastSms();
                this.log.debug((Object)("attempts: " + (attempts + 1)));
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        if (lastSmsText != null && lastSmsText.matches(pattern)) {
            return lastSmsText.replaceAll(pattern, "$2");
        }
        return "USSD: " + data + "| SMS: " + lastSmsText == null ? "-" : lastSmsText;
    }

    public String executeUssd(String request, String ussdRegex, String smsRegex, int smsTimeout) throws ModemException {
        this.selectSmsStorage("SM");
        this.smsClear();
        boolean pduRequire = ModemHelper.isPDURequire(this.getVendor());
        String data = this.executeUssd(request, pduRequire, 10000);
        data = data.replace("\n", "");
        this.log.info((Object)("data: " + data));
        if ((smsRegex == null || smsRegex.isEmpty()) && (ussdRegex == null || ussdRegex.isEmpty())) {
            ussdRegex = "^(.*)$";
        }
        if (ussdRegex != null && !ussdRegex.isEmpty() && data.matches(ussdRegex)) {
            return data.replaceAll(ussdRegex, "$1").trim();
        }
        if (smsRegex != null && !smsRegex.isEmpty()) {
            String lastSmsText = null;
            for (int attempts = 0; attempts < 20 && lastSmsText == null; ++attempts) {
                try {
                    Thread.sleep(smsTimeout);
                    lastSmsText = this.getLastSms();
                    this.log.debug((Object)("attempts: " + (attempts + 1)));
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            if (lastSmsText != null && (lastSmsText = lastSmsText.trim()).matches(smsRegex)) {
                return lastSmsText.replaceAll(smsRegex, "$1");
            }
            return "USSD: " + data + (lastSmsText == null ? "| SMS: -" : "| SMS: " + lastSmsText);
        }
        return "\u041e\u0442\u0432\u0435\u0442 \u043d\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d";
    }

    public boolean selectSmsStorage(String storage) throws ModemException {
        List<String> send = this.connector.send("AT+CPMS=" + storage, 5000);
        return send.size() > 0 && send.get(0).equalsIgnoreCase("OK");
    }

    private boolean listContainsOk(List<String> list) {
        if (list.size() == 1) {
            if (list.get(0).equalsIgnoreCase("ok")) {
                this.log.info((Object)"Response is interpreted as OK");
                return true;
            }
        } else if (list.size() > 1) {
            for (String field : list) {
                if (!field.equalsIgnoreCase("ok")) continue;
                this.log.info((Object)"Response is interpreted as OK");
                return true;
            }
        }
        return false;
    }
}

