/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.tbv100;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.tbv100.Connector;
import ru.softlogic.hardware.bvr.tbv100.Id003Status;
import ru.softlogic.hardware.bvr.tbv100.Info;
import ru.softlogic.hardware.bvr.tbv100.Note;
import ru.softlogic.hdw.WrongCommandException;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Api {
    public static final byte EUR = -32;
    public static final byte RUB = 39;
    public static final byte USD = 1;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(Api.class.getPackage().getName() + ".resource");
    private Connector conn;
    private SerialPort port;
    private Logger log;
    private final Map<String, Byte> map = new HashMap<String, Byte>();

    public Api(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("Port is null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Logger is null");
        }
        this.port = port;
        this.log = log;
        this.conn = new Connector(port, log);
    }

    public SerialPort getPort() {
        return this.port;
    }

    public final void open() throws IOException {
        this.conn.open();
    }

    public final void close() {
        this.conn.close();
    }

    public final Id003Status poll() throws IOException {
        byte[] data = this.conn.sendCommand((byte)17);
        return new Id003Status(data.length > 0 ? BU.c((byte)data[0]) : 0, data.length > 1 ? BU.c((byte)data[1]) : 0);
    }

    public final void reset() throws IOException {
        byte[] res = this.conn.sendCommand((byte)64);
        if (res.length != 1 || res[0] != 80) {
            throw new IOException("Wrong answer format");
        }
    }

    public final Info identification() throws IOException {
        byte[] data = this.conn.sendCommand((byte)-120);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char symbol = (char)data[i];
            sb.append(BU.isStringChar((char)symbol) ? symbol : (char)'?');
        }
        Info info = new Info();
        String[] paths = sb.toString().split(" (?![Vv])");
        if (paths.length == 4) {
            String[] paths2;
            Matcher m2 = Pattern.compile(".*\\((.*{3})\\)-?(.*)").matcher(paths[0]);
            if (m2.find()) {
                info.setCountry(m2.group(1));
                String[] paths1 = m2.group(2).split("-");
                if (paths1.length == 2) {
                    info.setModelNo(paths1[0]);
                    info.setStackerType(paths1[1]);
                } else {
                    info.setModelNo(paths1[0]);
                }
            }
            if ((paths2 = paths[1].split(" ?(v|V)")).length == 2) {
                info.setInterfaceType(paths2[0]);
                info.setSoftwareVersion(paths2[1]);
            }
            info.setSoftwareBuild(paths[2]);
        }
        return info;
    }

    public final String getBootVersion() throws IOException {
        byte[] data = this.conn.sendCommand((byte)-119);
        String str = "";
        for (int i = 1; i < data.length; ++i) {
            char symbol = (char)data[i];
            str = str + (BU.isStringChar((char)symbol) ? symbol : (char)'?');
        }
        return str;
    }

    public final void disable() throws IOException {
        byte mask = 1;
        this.conn.sendCommand((byte)-61, new byte[]{mask});
    }

    public final void enable() throws IOException {
        byte mask = 0;
        this.conn.sendCommand((byte)-61, new byte[]{mask});
    }

    public final void returnCash() throws IOException {
        this.conn.sendCommand((byte)67);
    }

    public final void stackCash() throws IOException {
        this.conn.sendCommand((byte)65);
    }

    public final void enableBillTypes() throws IOException {
        byte[] data = new byte[]{0, 0};
        this.conn.sendCommand((byte)-64, data);
    }

    public final void secure() throws IOException {
        byte[] data = new byte[]{0, 0};
        this.conn.sendCommand((byte)-63, data);
    }

    public final byte getActiveCountry() throws IOException {
        try {
            byte[] res = this.conn.sendCommand2((byte)-117, new byte[]{1});
            return res[2];
        }
        catch (WrongCommandException ex) {
            return 0;
        }
    }

    public final boolean setActiveCountry(byte country) throws IOException {
        try {
            this.conn.sendCommand2((byte)-53, new byte[]{1, country});
            return true;
        }
        catch (WrongCommandException ex) {
            return false;
        }
    }

    public final Note[] getNotes(byte country) throws IOException {
        try {
            byte[] res = this.conn.sendCommand2((byte)-117, new byte[]{3, country});
            LinkedList<Note> notes = new LinkedList<Note>();
            for (int i = 0; i < res.length / 4; ++i) {
                int id = BU.c((byte)res[i * 4 + 2]);
                int cn = BU.c((byte)res[i * 4 + 3]);
                int nm = BU.c((byte)res[i * 4 + 4]);
                if (id <= 0 || cn <= 0 || nm <= 0) continue;
                notes.add(new Note(id, cn, (int)((double)nm * Math.pow(10.0, BU.c((byte)res[i * 4 + 5])))));
            }
            return notes.toArray(new Note[notes.size()]);
        }
        catch (WrongCommandException ex) {
            return null;
        }
    }

    public final byte[] getSupportCountries() throws IOException {
        try {
            byte[] res = this.conn.sendCommand2((byte)-117, new byte[]{2});
            byte[] r = new byte[res.length - 2];
            System.arraycopy(res, 2, r, 0, r.length);
            return r;
        }
        catch (WrongCommandException ex) {
            return new byte[0];
        }
    }

    public String getCurrency(byte countryId) {
        try {
            return bundle.getString("country." + String.format("%02x", countryId));
        }
        catch (MissingResourceException ex) {
            return "UNK";
        }
    }

    public byte getCountryId(String curr) {
        Byte b = this.map.get(curr);
        if (b == null) {
            try {
                b = BU.c((int)Integer.parseInt(bundle.getString("curr." + curr), 16));
            }
            catch (MissingResourceException ex) {
                b = 0;
            }
            this.map.put(curr, b);
        }
        return b;
    }

    public String getCurrencies(byte[] countryes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < countryes.length; ++i) {
            byte b = countryes[i];
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.getCurrency(b));
        }
        return sb.toString();
    }

    public Connector getConnector() {
        return this.conn;
    }
}

