/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.smpt.driver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.smpt.driver.PayoutManagerStub;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.ClearListener;
import ru.softlogic.hdw.dev.cashacc.PayoutModule;
import ru.softlogic.hdw.dev.cashacc.PayoutModuleManager;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.dev.cashdisp.OperationDispenseResult;
import ru.softlogic.hdw.dev.cashdisp.OperationListener;
import ru.softlogic.hdw.dev.cashdisp.PayoutBySetOperation;
import ru.softlogic.hdw.dev.cashdisp.PayoutException;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.proto.essp.Banknote;
import ru.softlogic.hdw.proto.essp.IncompleteSum;
import ru.softlogic.hdw.proto.essp.SSPApi;
import ru.softlogic.hdw.proto.essp.SSPException;
import ru.softlogic.hdw.proto.essp.StateAdapter;
import ru.softlogic.hdw.proto.essp.StateHandler;
import ru.softlogic.hdw.proto.essp.ValidatorSetup;
import ru.softlogic.hdw.proto.essp.WrongSequenceException;
import ru.softlogic.hdw.proto.essp.eSSPException;
import ru.softlogic.hdw.proto.essp.m;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.BoxInfo;

public class Driver
extends BaseCashAcceptorDriver
implements PayoutModule {
    private static final String DRIVER_VERSION = "2.0.0";
    private static final int PROTO = 6;
    private final SerialPort port;
    private final SSPApi api;
    private final Logger log;
    private ValidatorSetup setup;
    private Map<Integer, Denomination> units;
    private Map<Banknote, Denomination> um;
    private PayoutModuleManager manager = new PayoutManagerStub();
    private boolean localEnabled;
    private ClearListener clearListener;
    private Map<Banknote, Integer> clearLevels;
    private Map<Banknote, Integer> levels;
    private OperationListener operationListener;
    private Map<Denomination, Integer> initialCounts;

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, currency, log);
        this.port = port;
        this.api = new SSPApi(port, 0, log);
        this.log = log;
    }

    protected void _run() throws InterruptedException {
        StateHandler sh = new StateHandler(new LocalStateListener(), 6, this.log);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.setup == null) {
                    this.init();
                }
                this.checkEnable();
                this.poll(sh);
                this.sleep(200);
            }
            catch (IOException | SSPException | eSSPException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                this.notifyConnErrorAndReset(ex);
                this.setup = null;
                this.localEnabled = false;
                this.api.close();
                if (this.operationListener != null) {
                    this.operationListener.onError();
                    this.operationListener = null;
                }
                this.randomSleep(500, 500);
            }
        }
    }

    private synchronized void poll(StateHandler sh) throws IOException, SSPException {
        sh.process(this.api.poll());
    }

    private synchronized void checkEnable() throws IOException {
        boolean enable = this.isEnabled();
        if (enable != this.localEnabled) {
            if (enable) {
                this.processRoutes();
                this.api.enable();
                this.api.setChannelInhibits(255);
            } else {
                this.api.disable();
                this.api.setChannelInhibits(0);
            }
            this.localEnabled = enable;
        }
    }

    private synchronized void init() throws IOException, eSSPException, SSPException {
        try {
            this.log.info((Object)"Open port");
            this.api.open();
            this.log.info((Object)("Sync: " + m.get(this.api.sync())));
            this.log.info((Object)("Sync: " + m.get(this.api.sync())));
            this.log.info((Object)("Sync: " + m.get(this.api.sync())));
            this.api.setHostProtocol(6);
            int serial = this.api.getSerial();
            this.log.info((Object)("Serial: " + serial));
            String firmware = this.api.getFirmware();
            this.log.info((Object)("Firmware: " + firmware));
            String dataset = this.api.getDataset();
            this.log.info((Object)("Dataset: " + dataset));
            int unitType = this.api.getUnitType();
            this.log.info((Object)("Unit type: " + m.getUnitName(unitType) + ", id=" + unitType));
            this.api.disable();
            this.api.setChannelInhibits(0);
            this.log.info((Object)"Get device setup:");
            this.setup = this.api.getValidatorSetup();
            this.log.info((Object)("   Firmware: " + this.setup.getFirmvare()));
            this.log.info((Object)("   Country: " + this.setup.getMainCountryCode()));
            this.log.info((Object)("   Multiplier: " + this.setup.getMuliplier()));
            this.log.info((Object)("   Proto: " + this.setup.getProto()));
            this.log.info((Object)("   Secures: " + Arrays.toString(this.setup.getSecures())));
            this.api.createEncryptedLayer(SSPApi.ITL_KEY);
            try {
                this.api.eventAsk();
            }
            catch (SSPException sSPException) {
                // empty catch block
            }
            this.units = new HashMap<Integer, Denomination>();
            this.um = new HashMap<Banknote, Denomination>();
            HashSet<Denomination> den = new HashSet<Denomination>();
            LinkedHashSet<String> uniques = new LinkedHashSet<String>();
            this.log.info((Object)"   Banknotes: ");
            Banknote[] bns = this.setup.getBanknotes();
            for (int i = 0; i < bns.length; ++i) {
                Banknote bn = bns[i];
                uniques.add(bn.getNominal() + bn.getCountry());
                Denomination d = this.getBill(bn.getCountry(), bn.getNominal());
                this.log.info((Object)("      " + bn.toString() + "->" + d));
                try {
                    this.log.info((Object)("        level->" + this.api.getDenominationLevel(bn)));
                }
                catch (SSPException ex) {
                    this.log.info((Object)("        level->UNKNOWN(" + ex.getMessage() + ")"));
                }
                this.units.put(i, d);
                this.um.put(bn, d);
                if (d != null) {
                    den.add(d);
                }
                try {
                    this.api.setRouting(1, bn);
                    continue;
                }
                catch (SSPException ex) {
                    this.log.error((Object)("Can't route " + bn + " to cash box"));
                }
            }
            HashMap<Integer, BoxInfo> boxes = new HashMap<Integer, BoxInfo>();
            boxes.put(1, new BoxInfo(0, Integer.valueOf(1000), 1));
            boxes.put(1, new BoxInfo(1, Integer.valueOf(80), 2));
            DeviceInfo di = this.createDeviceInfo("ITL", "eSPP", DRIVER_VERSION, den, boxes);
            di.setSerial(Integer.toString(serial));
            di.setFirmware(firmware);
            di.setFirmware1("Dataset=" + dataset);
            di.setInfo(firmware);
            di.setModel(m.getUnitName(unitType));
            di.setInfo(((Object)uniques).toString());
            this.updateDeviceInfo(di);
            this.updateState(0);
            this.log.info((Object)"-------");
        }
        catch (WrongSequenceException ex) {
            this.log.error((Object)"Wrong sequence");
        }
    }

    private Denomination get(int channel) {
        return this.units.get(channel - 1);
    }

    public synchronized void payout(PayoutBySetOperation operation) throws PayoutException {
        Map req = operation.getCounts().getCounts();
        HashMap<Banknote, Integer> ps = new HashMap<Banknote, Integer>();
        for (Map.Entry entry : req.entrySet()) {
            ps.put(new Banknote(((Denomination)entry.getKey()).getNominal(), ((Denomination)entry.getKey()).getCurrency()), (Integer)entry.getValue());
        }
        this.log.info((Object)("Hdw request: " + ps));
        this.log.info((Object)"Try to payout");
        try {
            this.initialCounts = this.getCounts();
            this.log.info((Object)("Initial counts: " + this.initialCounts));
            this.operationListener = operation.getListener();
            this.api.payoutByDenomination(88, ps);
            this.log.info((Object)"Done");
        }
        catch (IOException | SSPException ex) {
            this.operationListener = null;
            this.log.error((Object)"Error on process command");
            throw new PayoutException((Throwable)ex);
        }
    }

    public PayoutModule getPayoutApi() {
        return this;
    }

    public synchronized Map<Denomination, Integer> getCounts() throws PayoutException {
        try {
            Map<Banknote, Integer> l = this.api.getAllLevels();
            HashMap<Denomination, Integer> res = new HashMap<Denomination, Integer>();
            for (Map.Entry<Banknote, Integer> entry : l.entrySet()) {
                res.put(this.um.get(entry.getKey()), entry.getValue());
            }
            return res;
        }
        catch (IOException | SSPException ex) {
            throw new PayoutException((Throwable)ex);
        }
    }

    public synchronized void clear(ClearListener clearListener) throws PayoutException {
        if (clearListener == null) {
            throw new NullPointerException("ClearListener is null");
        }
        this.checkBusy();
        try {
            this.log.info((Object)"Request levels: ");
            this.clearLevels = this.api.getAllLevels();
            this.log.info((Object)("Result: " + this.clearLevels));
            this.clearListener = clearListener;
            this.log.info((Object)"Begin empty");
            this.api.emptyAll();
        }
        catch (IOException | SSPException ex) {
            throw new PayoutException("Error on clean", (Throwable)ex);
        }
    }

    public void setManager(PayoutModuleManager manager) {
        if (manager == null) {
            throw new NullPointerException("PayoutManager is null");
        }
        this.manager = manager;
    }

    private void processRoutes() throws IOException {
        this.log.info((Object)"Process routes");
        try {
            boolean enablePayout = false;
            this.levels = new HashMap<Banknote, Integer>();
            for (Banknote bn : this.setup.getBanknotes()) {
                Denomination d = this.um.get(bn);
                if (d != null) {
                    int has = this.api.getDenominationLevel(bn);
                    this.levels.put(bn, has);
                    int max = this.manager.getMaxCount(d);
                    this.log.info((Object)("    " + d + ", has: " + has + ", max: " + max));
                    if (has < max) {
                        this.log.info((Object)"      ->TO PAYOUT");
                        this.api.setRouting(0, bn);
                        enablePayout = true;
                        continue;
                    }
                    this.log.info((Object)"      ->TO CASH BOX");
                    this.api.setRouting(1, bn);
                    continue;
                }
                this.log.info((Object)"    Unknown nominal");
                this.log.info((Object)"      ->TO CASH BOX");
                this.api.setRouting(1, bn);
            }
            if (enablePayout) {
                this.log.info((Object)"Try to enable payout device");
                this.api.enablePayoutDevice();
                this.log.info((Object)"Done");
            }
        }
        catch (SSPException ex) {
            this.log.error((Object)("Can't process routing: " + ex.getMessage()));
            this.notifyProblemOnce("Can't process routing: " + ex.getMessage());
        }
        this.log.info((Object)"Done");
    }

    private void checkBusy() {
    }

    private Banknote convert(Denomination d) {
        for (Banknote b : this.um.keySet()) {
            if (!this.um.get(b).equals((Object)d)) continue;
            return b;
        }
        return null;
    }

    private void processResult() {
        try {
            this.api.eventAsk();
        }
        catch (IOException | SSPException ex) {
            this.log.error((Object)("Error on process event/ack: " + ex.getMessage()));
        }
        try {
            Map<Denomination, Integer> finalCounts = this.getCounts();
            this.log.info((Object)("Final counts: " + finalCounts));
            DenominationSet ds = new DenominationSet();
            for (Map.Entry<Denomination, Integer> entry : this.initialCounts.entrySet()) {
                int cnt = entry.getValue() - finalCounts.getOrDefault(entry.getKey(), 0);
                if (cnt <= 0) continue;
                ds.add(entry.getKey(), cnt);
            }
            this.log.info((Object)("Result: " + ds));
            BoxId boxId = new BoxId(this.getDeviceId().getDeviceClass(), this.getDeviceId().getNumber(), 0);
            OperationDispenseResult result = new OperationDispenseResult(Collections.singletonMap(boxId, ds));
            this.operationListener.onResult(result);
        }
        catch (PayoutException ex) {
            this.log.error((Object)("Error on process result: " + ex.getMessage()));
        }
        this.operationListener = null;
    }

    private boolean isReject(Denomination denomination) {
        if (!this.canStack(denomination)) {
            this.log.info((Object)"Can't stack, try reject banknote");
            try {
                this.api.rejectBanknote();
                return true;
            }
            catch (IOException | SSPException ex) {
                this.log.error((Object)"Can't reject banknote");
            }
        }
        return false;
    }

    private class LocalStateListener
    extends StateAdapter {
        private Denomination unit;
        private Banknote bn;

        private LocalStateListener() {
        }

        @Override
        public void onRead(int channel) {
            if (channel == 0) {
                Driver.this.log.info((Object)"Accepting");
                Driver.this.notifyEvent(1);
            } else {
                this.unit = Driver.this.get(channel);
                Driver.this.log.info((Object)("Accepting: " + this.unit));
                Driver.this.isReject(this.unit);
            }
        }

        @Override
        public void onSlaveReset() {
            Driver.this.log.info((Object)"Slave reset");
            Driver.this.notifySafeState(true);
        }

        @Override
        public void onStacking() {
            Driver.this.notifySafeState(false);
            if (Driver.this.isReject(this.unit)) {
                Driver.this.notifySafeState(true);
            }
        }

        @Override
        public void onCredit(int channel) {
            this.unit = Driver.this.get(channel);
            this.bn = Driver.this.setup.getBanknotes()[channel - 1];
            Driver.this.log.info((Object)("Credit: " + channel + ", unit=" + this.unit));
            if (Driver.this.isReject(this.unit)) {
                Driver.this.notifySafeState(true);
            }
        }

        @Override
        public void onStacked() {
            Driver.this.log.info((Object)"Notify cash storage");
            Driver.this.stack(this.unit);
            Driver.this.log.info((Object)("Bill stacked " + this.unit));
            Driver.this.notifyEvent(7);
            Driver.this.notifySafeState(true);
            Driver.this.updateState(0);
        }

        @Override
        public void onBoxReplaced() {
            Driver.this.updateState(0);
        }

        @Override
        public void onBoxRemoved() {
            Driver.this.updateState(2);
        }

        @Override
        public void onStackerFull() {
            Driver.this.updateState(1);
        }

        @Override
        public void onSafeJam() {
            Driver.this.updateState(3);
        }

        @Override
        public void onUnsafeJam() {
            Driver.this.updateState(3);
        }

        @Override
        public void onStoredInPayout() {
            try {
                Driver.this.stackToPayout(this.unit);
                Driver.this.notifySafeState(true);
                int level = (Integer)Driver.this.levels.get(this.bn) + 1;
                Driver.this.levels.put(this.bn, level);
                int max = Driver.this.manager.getMaxCount(this.unit);
                if (level >= max) {
                    Driver.this.log.info((Object)("    " + this.unit + ", has: " + level + ", max: " + max));
                    Driver.this.log.info((Object)"      ->CHANGE ROUTE TO CASH BOX");
                    Driver.this.api.setRouting(1, this.bn);
                }
            }
            catch (IOException | SSPException ex) {
                Driver.this.log.info((Object)("Error on load: " + ex.getMessage()));
            }
        }

        @Override
        public void onDisabled() {
        }

        @Override
        public void onRejecting() {
            Driver.this.notifySafeState(true);
        }

        @Override
        public void onRejected() {
            Driver.this.notifyEvent(2);
            try {
                int code = Driver.this.api.getLastRejectCode();
                Driver.this.log.info((Object)("Reject cause: " + m.getRejectError(code)));
            }
            catch (IOException | SSPException ex) {
                Driver.this.log.error((Object)"Error on get reject cause", (Throwable)ex);
            }
        }

        @Override
        public void onEmpted() {
            Driver.this.log.info((Object)"Notify clear listener");
            if (Driver.this.clearListener != null) {
                Driver.this.clearListener.onFinish();
            }
            Driver.this.clearListener = null;
        }

        @Override
        public void onDispensed(List<Sum> list) {
            Driver.this.processResult();
        }

        @Override
        public void onIncompletePayout(List<IncompleteSum> list) {
            Driver.this.processResult();
        }
    }
}

