/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.id003.search;

import java.io.IOException;
import ru.softlogic.hardware.bvr.tbv100.Api;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Searchable
extends BaseSearchable {
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        Api api = new Api(port, this.log);
        api.getConnector().setAttempts(1);
        api.getConnector().setAttemptPause(0);
        api.getConnector().setIoTimeout(100);
        try {
            api.open();
            api.identification();
            api.poll();
            if (api.getActiveCountry() > 0) {
                DeviceDescription deviceDescription = this.createDescriptor("bvr", "tbv100");
                return deviceDescription;
            }
            DeviceDescription deviceDescription = null;
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            api.close();
        }
    }

    public SerialParams[] getSearchParams(int priority) {
        if (priority == 0) {
            return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even)};
        }
        if (priority == 1) {
            return new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.Even)};
        }
        if (priority == 4) {
            return new SerialParams[]{new SerialParams(38200, DataBits.Eight, StopBits.One, Parity.Even)};
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 55;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 3);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }
}

