/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.id003.driver;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.tbv100.Api;
import ru.softlogic.hardware.bvr.tbv100.Id003Status;
import ru.softlogic.hardware.bvr.tbv100.Info;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Driver
extends BaseCashAcceptorDriver {
    private static final String DRIVER_VERSION = "2.0.2";
    private final Api api;
    private final String currency;
    private final Logger log;
    private int resetCount;
    private Map<Integer, Denomination> bills = new HashMap<Integer, Denomination>();
    private boolean hasIdle;

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, currency, log);
        this.api = new Api(port, log);
        this.currency = currency;
        this.log = log;
    }

    protected void _run() throws InterruptedException {
        boolean canStake = false;
        Id003Status lastStatus = null;
        Denomination den = null;
        this.bills = this.loadTable(this.currency);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (lastStatus == null) {
                    this.log.info((Object)"Last status is null. Send reset");
                    this.api.open();
                    this.log.info((Object)"Port is open. Reset");
                    this.api.reset();
                    this.log.info((Object)"Done, start pooling");
                }
                this.sleep(150);
                Id003Status currStatus = this.api.poll();
                if (!currStatus.equals(lastStatus)) {
                    this.log.info((Object)("Current status: " + currStatus));
                }
                if (lastStatus != null && lastStatus.getStatus() == 27 && !lastStatus.equals(currStatus)) {
                    this.init(currStatus);
                }
                switch (currStatus.getStatus()) {
                    case 26: {
                        this.resetCount = 0;
                        if (!this.isEnabled()) break;
                        this.api.enable();
                        this.hasIdle = false;
                        break;
                    }
                    case 17: {
                        this.resetCount = 0;
                        if (this.isEnabled()) break;
                        this.api.disable();
                        if (this.hasIdle) break;
                        this.updateState(0, 1);
                    }
                }
                if (currStatus.equals(lastStatus)) continue;
                block5 : switch (currStatus.getStatus()) {
                    case 64: 
                    case 65: 
                    case 66: {
                        this.log.info((Object)"Power up");
                        this.api.reset();
                        break;
                    }
                    case 18: {
                        this.log.info((Object)"Accepting");
                        this.notifyEvent(1);
                        break;
                    }
                    case 20: {
                        this.log.info((Object)"Stacking");
                        break;
                    }
                    case 24: {
                        this.log.info((Object)"Return");
                        break;
                    }
                    case 25: {
                        this.log.info((Object)"Hold");
                        break;
                    }
                    case 21: {
                        this.log.info((Object)"Vend valid");
                        break;
                    }
                    case 67: {
                        this.log.info((Object)"Stask overflow");
                        this.updateState(1);
                        break;
                    }
                    case 68: {
                        this.log.info((Object)"Stack out");
                        this.updateState(2);
                        break;
                    }
                    case 69: {
                        this.log.info((Object)"Bill jamm in head");
                        this.updateState(3);
                        this.tryRestore();
                        break;
                    }
                    case 70: {
                        this.log.info((Object)"Bill jamm in stack");
                        this.updateState(4);
                        this.tryRestore();
                        break;
                    }
                    case 71: {
                        this.log.info((Object)"Pause");
                        this.updateState(3);
                        break;
                    }
                    case 72: {
                        this.log.info((Object)"Cheat?");
                        break;
                    }
                    case 19: {
                        this.log.info((Object)"Escrow position");
                        this.log.info((Object)("code=" + currStatus.getSubStatus()));
                        den = this.getDenomination(currStatus.getSubStatus());
                        this.notifySafeState(false);
                        if (this.canStack(den)) {
                            canStake = true;
                            this.api.stackCash();
                            break;
                        }
                        this.log.info((Object)"Stack cash is not permit");
                        this.api.returnCash();
                        this.notifySafeState(true);
                        break;
                    }
                    case 22: {
                        if (canStake) {
                            this.stack(den);
                            this.notifyEvent(7);
                        } else {
                            this.log.error((Object)"Flag CanStack is not set, Can't add bill");
                        }
                        this.notifySafeState(true);
                        canStake = false;
                        break;
                    }
                    case 23: {
                        switch (currStatus.getSubStatus()) {
                            case 113: {
                                this.log.info((Object)"Reject: insert error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 114: {
                                this.log.info((Object)"Reject: mag error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 115: {
                                this.log.info((Object)"Reject: previos bill in head");
                                this.notifyEvent(2);
                                break;
                            }
                            case 116: {
                                this.log.info((Object)"Reject: multiple factor error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 117: {
                                this.log.info((Object)"Reject: transport error");
                                this.notifyEvent(6);
                                break;
                            }
                            case 118: {
                                this.log.info((Object)"Reject: denominating assession error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 119: {
                                this.log.info((Object)"Reject: photo pattern error 1");
                                this.notifyEvent(2);
                                break;
                            }
                            case 120: {
                                this.log.info((Object)"Reject: photo level error");
                                this.notifyEvent(3);
                                break;
                            }
                            case 121: {
                                this.log.info((Object)"Reject: inhibit error");
                                break;
                            }
                            case 122: {
                                this.log.info((Object)"Reject: 0x7a");
                                this.notifyEvent(2);
                                break;
                            }
                            case 123: {
                                this.log.info((Object)"Reject: operation error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 124: {
                                this.log.info((Object)"Reject: rejecting action by remaining of bill and such");
                                this.notifyEvent(2);
                                break;
                            }
                            case 125: {
                                this.log.info((Object)"Reject: length error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 126: {
                                this.log.info((Object)"Reject: photo pattern error 2");
                                this.notifyEvent(2);
                                break;
                            }
                            default: {
                                this.notifyProblemOnce("Unknown substate " + BU.toHex((int)currStatus.getSubStatus()) + " for state " + BU.toHex((int)currStatus.getStatus()));
                            }
                        }
                        this.notifySafeState(true);
                        break;
                    }
                    case 73: {
                        switch (currStatus.getSubStatus()) {
                            case 162: {
                                this.log.info((Object)"Fail: stack motor");
                                this.updateState(5);
                                break block5;
                            }
                            case 165: 
                            case 166: {
                                this.log.info((Object)"Fail: transport motor");
                                this.updateState(6);
                                break block5;
                            }
                            case 171: {
                                this.log.info((Object)"Fail: init stack");
                                this.updateState(8);
                                break block5;
                            }
                            case 175: {
                                this.log.info((Object)"fail: validator head remove");
                                this.updateState(8);
                                break block5;
                            }
                            case 176: {
                                this.log.info((Object)"fail: boot rom  failure");
                                this.updateState(12);
                                this.tryRestore();
                                break block5;
                            }
                            case 177: {
                                this.log.info((Object)"fail: external rom  failure");
                                this.updateState(12);
                                this.tryRestore();
                                break block5;
                            }
                            case 178: {
                                this.log.info((Object)"fail: rom  failure");
                                this.updateState(12);
                                this.tryRestore();
                                break block5;
                            }
                            case 179: {
                                this.log.info((Object)"fail: external rom  write failure");
                                this.updateState(12);
                                break block5;
                            }
                        }
                        this.notifyProblemOnce("Unknown substate " + BU.toHex((int)currStatus.getSubStatus()) + " for state " + BU.toHex((int)currStatus.getStatus()));
                        this.updateState(-7);
                        break;
                    }
                    case 26: {
                        this.log.info((Object)"unit disable");
                        this.updateState(0);
                        this.notifySafeState(true);
                        break;
                    }
                    case 17: {
                        this.log.info((Object)"idle");
                        this.hasIdle = true;
                        this.updateState(0);
                        this.notifySafeState(true);
                        break;
                    }
                    case 27: {
                        this.log.info((Object)"init");
                        break;
                    }
                    default: {
                        this.notifyProblemOnce("Unknown event type " + BU.toHex((int)currStatus.getSubStatus()));
                    }
                }
                lastStatus = currStatus;
            }
            catch (IOException ex) {
                this.onConnError(ex);
                this.randomSleep(500, 500);
                lastStatus = null;
                this.api.close();
            }
        }
    }

    private void init(Id003Status currStatus) throws IOException {
        this.log.debug((Object)"Init done. Set options");
        DeviceInfo info = this.createDeviceInfo("", "ID003", DRIVER_VERSION, new HashSet<Denomination>(this.bills.values()));
        Info id003Info = this.api.identification();
        info.setModel(id003Info.getModelNo() + "-" + id003Info.getStackerType());
        info.setProto(id003Info.getInterfaceType());
        info.setFirmware(id003Info.getSoftwareVersion());
        String boot = this.api.getBootVersion();
        info.setFirmware1("boot=" + boot);
        this.log.info((Object)("boot version=" + boot));
        this.updateDeviceInfo(info);
        if (currStatus.getStatus() == 26) {
            this.log.debug((Object)"Set enable bill types");
            this.api.enableBillTypes();
            this.log.debug((Object)"Set secure bill types");
            this.api.secure();
        }
    }

    private void tryRestore() throws IOException {
        ++this.resetCount;
        if (this.resetCount < 5) {
            this.api.reset();
        }
    }

    private Denomination getDenomination(int code) throws IOException {
        return this.bills.get(code);
    }
}

