/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.gpt22.driver;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.gpt22.Api;
import ru.softlogic.hardware.bvr.gpt22.GptStatus;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.BvrState;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Driver
extends BaseCashAcceptorDriver {
    private static final String DRIVER_VERSION = "2.0.0";
    private final Api api;
    private final Logger log;
    private final String currency;
    private Map<Integer, Denomination> bills = new HashMap<Integer, Denomination>();

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, currency, log);
        this.api = new Api(port, log);
        this.currency = currency;
        this.log = log;
    }

    protected void _run() throws InterruptedException {
        GptStatus lastStatus = null;
        boolean canStake = false;
        this.bills = this.loadTable(this.currency);
        while (!Thread.currentThread().isInterrupted()) {
            this.sleep(250);
            try {
                if (lastStatus == null) {
                    this.log.info((Object)"Try to open port");
                    this.api.open();
                    this.init();
                }
                GptStatus status = this.api.requestStatus();
                if (this.isEnabled()) {
                    if (!status.isIdle()) {
                        this.log.info((Object)"Enable hardware");
                        this.api.setBillEnables(65535);
                    }
                } else if (status.isIdle()) {
                    this.log.info((Object)"Disable hardware");
                    this.api.setBillEnables(0);
                }
                if (!status.equals(lastStatus)) {
                    this.api.debugData(status);
                }
                if (status.isIdle() && (lastStatus == null || !lastStatus.isIdle())) {
                    this.log.info((Object)"Idling");
                    this.updateState(0);
                }
                if (status.isAccepting() && (lastStatus == null || !lastStatus.isAccepting())) {
                    this.log.info((Object)"Accepting");
                    this.notifyEvent(1);
                    Thread.sleep(2000L);
                }
                if (status.isEscrow() && (lastStatus == null || !lastStatus.isEscrow())) {
                    this.notifySafeState(false);
                    this.log.info((Object)"Escrow position");
                    Denomination d = this.getDenomination(status);
                    if (this.canStack(d)) {
                        this.log.info((Object)"Stack bill...");
                        canStake = true;
                        this.api.acceptBill();
                    } else {
                        this.api.returnBill();
                        this.notifySafeState(true);
                    }
                }
                if (status.isStacking() && (lastStatus == null || !lastStatus.isStacking())) {
                    this.log.info((Object)"Stacking");
                }
                if (status.isBillStacked() && (lastStatus == null || !lastStatus.isBillStacked())) {
                    this.log.info((Object)"Stacked");
                    this.updateState((DeviceState)new BvrState(0));
                    if (canStake) {
                        this.stack(this.getDenomination(status));
                        this.notifyEvent(7);
                        canStake = false;
                    } else {
                        this.log.error((Object)"Flag CanStack is not set, Can't add bill");
                    }
                    this.notifySafeState(true);
                }
                if (status.isReturning() && (lastStatus == null || !lastStatus.isReturning())) {
                    this.log.info((Object)"Returning");
                }
                if (status.isBillReturned() && (lastStatus == null || !lastStatus.isBillReturned())) {
                    this.log.info((Object)"Returned");
                }
                if (status.isCheat() && (lastStatus == null || !lastStatus.isCheat())) {
                    this.log.info((Object)"Cheated");
                    this.notifyFraud(0);
                }
                if (status.isRejecting() && (lastStatus == null || !lastStatus.isRejecting())) {
                    int rc = status.getRejectingCode();
                    this.log.info((Object)("Rejected, code: " + BU.toHex((int)rc) + ", cause: " + this.api.getRejectMessage(rc)));
                    this.notifyEvent(2);
                    if (rc == 7 || rc == 8 || rc == 12 || rc == 18) {
                        this.notifyFraud(2);
                    } else {
                        this.notifyFraud(3);
                    }
                }
                if (status.isStackerJamm() && (lastStatus == null || !lastStatus.isStackerJamm())) {
                    this.log.info((Object)"Jammed");
                    this.updateState(3);
                }
                if (status.isStackerFull() && (lastStatus == null || !lastStatus.isStackerFull())) {
                    this.log.info((Object)"StackerFull");
                    this.updateState(1);
                }
                if (status.isStackerOff() && (lastStatus == null || !lastStatus.isStackerOff())) {
                    this.log.info((Object)"Stack out");
                    this.updateState(2);
                }
                if (status.isPowerOn() && (lastStatus == null || !lastStatus.isPowerOn())) {
                    this.log.info((Object)"Power on");
                }
                if (status.isUpWithBill() && (lastStatus == null || !lastStatus.isUpWithBill())) {
                    this.log.info((Object)"Power on with bill");
                }
                if (status.isInhibit() && (lastStatus == null || !lastStatus.isInhibit())) {
                    this.log.info((Object)"Inhibit");
                    this.api.setInhibit(false);
                }
                lastStatus = status;
                this.onConnSuccess();
            }
            catch (IOException ex) {
                this.onConnError(ex);
                this.randomSleep(500, 500);
                lastStatus = null;
                this.api.close();
            }
        }
    }

    private Denomination getDenomination(GptStatus status) throws IOException {
        return this.bills.get(status.getBillType());
    }

    private void init() throws IOException, InterruptedException {
        this.log.info((Object)"------------------------------------------------------------------------");
        this.log.info((Object)"Reset");
        this.api.reset();
        Thread.sleep(3500L);
        this.log.info((Object)"Success");
        this.api.setMode(3);
        this.api.setStackerRequire(false);
        this.api.setInhibit(false);
        this.api.setBillEnables(0);
        this.log.info((Object)"--------------------------");
        this.log.info((Object)"Bill validator info:");
        DeviceInfo info = this.createDeviceInfo("Aurora", "GPT", DRIVER_VERSION, new HashSet<Denomination>(this.bills.values()));
        info.setFirmware(this.api.requestProgramRevision());
        info.setSerial(this.api.requestSerial());
        this.updateState(0);
        this.log.info((Object)("Serial: " + info.getSerial()));
        this.log.info((Object)("Programm revision: " + info.getFirmware()));
        this.log.info((Object)"---");
        this.updateDeviceInfo(info);
    }
}

