/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.gpt22;

import java.util.Arrays;
import ru.softlogic.io.utils.BU;

public class GptStatus {
    private final byte[] data;
    private final byte[] barcode;

    public GptStatus(byte[] data, byte[] barcode) {
        if (data == null || data.length != 3) {
            throw new IllegalArgumentException("data size must be 3 bytes");
        }
        this.data = data;
        this.barcode = barcode;
    }

    public boolean isBillStacked() {
        return (this.data[0] & 0x80) != 0;
    }

    public boolean isBillReturned() {
        return (this.data[0] & 0x40) != 0;
    }

    public boolean isEscrow() {
        return (this.data[0] & 0x20) != 0;
    }

    public boolean isCheat() {
        return (this.data[1] & 0x80) != 0;
    }

    public boolean isPowerOn() {
        return (this.data[1] & 0x40) != 0;
    }

    public boolean isInvalidEscrow() {
        return (this.data[1] & 0x20) != 0;
    }

    public boolean isRejecting() {
        return (this.data[1] & 0x10) != 0;
    }

    public boolean isStacking() {
        return (this.data[1] & 8) != 0;
    }

    public boolean isReturning() {
        return (this.data[1] & 4) != 0;
    }

    public boolean isAccepting() {
        return (this.data[1] & 2) != 0;
    }

    public boolean isIdle() {
        return (this.data[1] & 1) != 0 && !this.isBillStacked();
    }

    public boolean isInhibit() {
        return (this.data[2] & 0x80) != 0;
    }

    public boolean isDisabled() {
        return (this.data[2] & 0x40) != 0;
    }

    public boolean isTimeOut() {
        return (this.data[2] & 0x20) != 0;
    }

    public boolean isUpWithBill() {
        return (this.data[2] & 0x10) != 0;
    }

    public boolean isStackerFull() {
        return (this.data[2] & 8) != 0;
    }

    public boolean isStackerOff() {
        return false;
    }

    public boolean isStackerJamm() {
        return (this.data[2] & 2) != 0;
    }

    public boolean isBillJam() {
        return (this.data[2] & 1) != 0;
    }

    public Integer getBillType() {
        return this.isEscrow() || this.isBillStacked() ? Integer.valueOf(this.data[0] & 0x1F) : null;
    }

    public Integer getRejectingCode() {
        return this.isRejecting() ? Integer.valueOf(this.data[0] & 0x1F) : null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GptStatus other = (GptStatus)obj;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public String toString() {
        return "GptStatus{data=" + BU.toString((byte[])this.data) + ", bar=" + BU.toString((byte[])this.barcode) + '}';
    }
}

