/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.gpt22;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connector {
    private static final int STX = 2;
    private static final int ACK = 0;
    private static final int NAK = 255;
    private static final int IRQ = 85;
    private final SerialPort port;
    private final Logger log;
    private int attemptCount = 3;
    private int attemptsPause = 500;
    private int defaultTimeout = 750;

    public Connector(SerialPort port, Logger log) {
        this.port = port;
        this.log = log;
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }

    public void setParams(int attemptCount, int defaultTimeout) {
        this.attemptCount = attemptCount;
        this.defaultTimeout = defaultTimeout;
    }

    public byte[] sendMessage(int cmd) throws IOException {
        return this.sendMessage(cmd, null, null);
    }

    public byte[] sendMessage(int cmd, byte[] data) throws IOException {
        return this.sendMessage(cmd, data, null);
    }

    public byte[] sendMessage(int cmd, byte[] data, Integer timeout) throws IOException {
        IOException last = null;
        byte[] request = this.getMessage(cmd, data);
        try {
            int i = 0;
            int nak = 0;
            while (i < this.attemptCount && nak < 10) {
                try {
                    this.port.flush(Flush.RxTx);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(">>" + BU.toString((byte[])request)));
                    }
                    this.port.setTimeout(timeout == null ? this.defaultTimeout : timeout);
                    this.port.write(request);
                    for (int j = 0; j < 100; ++j) {
                        int res = this.port.readByte();
                        if (res == 2) {
                            int len = this.port.readByte();
                            this.log.debug((Object)("answer len=" + len));
                            byte[] ans = this.port.read(len - 2);
                            byte[] full = new byte[len];
                            full[0] = 2;
                            full[1] = BU.c((int)len);
                            System.arraycopy(ans, 0, full, 2, ans.length);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("<< " + BU.toString((byte[])full)));
                            }
                            if (this.getCrc(full) != full[full.length - 1]) {
                                throw new IOException("CRC is not valid: " + BU.toString((byte[])full));
                            }
                            int code = BU.c((byte)full[2]);
                            if (code == 255) {
                                ++nak;
                                this.log.info((Object)"NAK, sleep 1 second");
                                last = new IOException("NAK");
                                Thread.sleep(1000L);
                                continue;
                            }
                            if (code != 0 && code != cmd) {
                                throw new IOException("Wrong answer: " + BU.toString((byte[])full));
                            }
                            byte[] result = new byte[full.length - 4];
                            System.arraycopy(full, 3, result, 0, result.length);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("<< data=" + BU.toString((byte[])result)));
                            }
                            return result;
                        }
                        this.log.debug((Object)("<< SPAM " + BU.toHex((int)res)));
                    }
                }
                catch (IOException ex) {
                    this.log.info((Object)("IO error " + ex.getMessage()));
                    last = ex;
                    if (++i + 1 >= this.attemptCount) continue;
                    Random rnd = new Random();
                    int r = rnd.nextInt(this.attemptsPause);
                    this.log.info((Object)("Sleep " + r + " msec"));
                    Thread.sleep(r);
                }
            }
        }
        catch (InterruptedException ex1) {
            Thread.currentThread().interrupt();
            throw new IOException(ex1);
        }
        throw new IOException("IO erron on " + this.attemptCount + " attempts", last);
    }

    public byte[] getMessage(int cmd, byte[] data) {
        byte[] req = new byte[4 + (data == null ? 0 : data.length)];
        req[0] = BU.c((int)2);
        req[1] = BU.c((int)req.length);
        req[2] = BU.c((int)cmd);
        if (data != null) {
            System.arraycopy(data, 0, req, 3, data.length);
        }
        req[req.length - 1] = this.getCrc(req);
        return req;
    }

    private byte getCrc(byte[] packet) {
        int crc = 0;
        for (int i = 0; i < packet.length - 1; ++i) {
            crc = (byte)(crc + packet[i]);
        }
        return (byte)(256 - crc);
    }
}

