/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.gpt22;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.gpt22.Connector;
import ru.softlogic.hardware.bvr.gpt22.GptStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Api {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(Api.class.getPackage().getName() + ".messages");
    public static final int MODE_POLLED = 1;
    public static final int MODE_ESCROW = 2;
    private final Connector conn;
    private final Logger log;

    public Api(SerialPort port, Logger log) {
        this.conn = new Connector(port, log);
        this.log = log;
    }

    public void open() throws IOException {
        this.conn.open();
    }

    public void close() {
        this.conn.close();
    }

    public Connector getConnector() {
        return this.conn;
    }

    public void reset() throws IOException {
        this.conn.sendMessage(54);
    }

    public void resetUnitSetup() throws IOException {
        this.conn.sendMessage(53);
    }

    public void resetStatistics() throws IOException {
        this.conn.sendMessage(50);
    }

    public void resetBillCounter() throws IOException {
        this.conn.sendMessage(52);
    }

    public void setInhibit(boolean inhibit) throws IOException {
        this.conn.sendMessage(inhibit ? 240 : 241);
    }

    public void setMode(int mode) throws IOException {
        this.conn.sendMessage(64, new byte[]{BU.c((int)mode)});
    }

    public void requestMode() throws IOException {
        this.conn.sendMessage(192);
    }

    public GptStatus requestStatus() throws IOException {
        byte[] res = this.conn.sendMessage(204);
        try {
            GptStatus s;
            if (res.length == 3) {
                s = new GptStatus(res, null);
            } else {
                byte[] st = new byte[3];
                System.arraycopy(res, 0, st, 0, 3);
                byte[] bar = new byte[res.length - 3];
                System.arraycopy(res, 3, bar, 0, bar.length);
                s = new GptStatus(st, bar);
            }
            return s;
        }
        catch (Throwable ex) {
            System.out.println("dd=" + BU.toString((byte[])res));
            throw new IOException(ex);
        }
    }

    public void setStackerRequire(boolean require) throws IOException {
        this.conn.sendMessage(require ? 70 : 69);
    }

    public void setBillEnables(int mask) throws IOException {
        this.conn.sendMessage(65, new byte[]{BU.c((int)mask), BU.c((int)(mask >> 8))});
    }

    public void requestBillEnables() throws IOException {
        this.conn.sendMessage(193);
    }

    public void setSecurityLevel(int mask) throws IOException {
        this.conn.sendMessage(66, new byte[]{BU.c((int)mask), BU.c((int)(mask >> 8))});
    }

    public void acceptBill() throws IOException {
        this.conn.sendMessage(128);
    }

    public void returnBill() throws IOException {
        this.conn.sendMessage(129);
    }

    public void readRealTimeClock() throws IOException {
        this.conn.sendMessage(209);
    }

    public String requestSerial() throws IOException {
        return this.bcdToString(this.conn.sendMessage(210));
    }

    public String requestAssetNumber() throws IOException {
        return this.bcdToString(this.conn.sendMessage(211));
    }

    public String requestFactoryNumber() throws IOException {
        return this.bcdToString(this.conn.sendMessage(212));
    }

    public String requestProgramRevision() throws IOException {
        return BU.safeConvert((byte[])this.conn.sendMessage(216)).trim();
    }

    public Date requestProductionDate() throws IOException {
        byte[] res = this.conn.sendMessage(213);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2000 + this.bcdToInt(res[0]));
        cal.set(3, this.bcdToInt(res[1]));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void debugData(GptStatus s) {
        this.log.info((Object)((s.isBillStacked() ? "*stcd" : "     ") + " " + (s.isEscrow() ? "*escd" : "     ") + "" + (s.isInvalidEscrow() ? "+inld" : "") + " " + (s.isBillReturned() ? "*retd" : "     ") + " " + (s.isIdle() ? "*idl" : "    ") + " " + (s.isAccepting() ? "*accg" : "     ") + " " + (s.isStacking() ? "*stcg" : "     ") + " " + (s.isCheat() ? "*che" : "    ") + " " + (s.isReturning() ? "*retg" : "     ") + " " + (s.isRejecting() ? "*rejg" : "     ") + " " + (s.isPowerOn() ? "*pon" : "    ") + "" + (s.isUpWithBill() ? "+wbil" : "") + " " + (s.isInhibit() ? "*ihb" : "    ") + " " + (s.isDisabled() ? "*dis" : "    ") + " " + (s.isTimeOut() ? "*to" : "   ") + " " + (s.isStackerFull() ? "*sful" : "     ") + " " + (s.isStackerOff() ? "*soff" : "     ") + " " + (s.isStackerJamm() ? "*sjam" : "     ") + " " + (s.isBillJam() ? "*bjam" : "     ") + "" + (s.getBillType() != null ? "|Bill type: " + s.getBillType() : "") + (s.getRejectingCode() != null ? "|Reject code: " + BU.toHex((int)s.getRejectingCode()) + "," + this.getRejectMessage(s.getRejectingCode()) : "")));
    }

    public String getRejectMessage(int code) {
        try {
            return bundle.getString("reject." + String.format("%02X", code));
        }
        catch (Throwable ex) {
            return "Unknown state " + code;
        }
    }

    public String getErrorMessage(int error) {
        try {
            return bundle.getString("error." + String.format("%02X", error));
        }
        catch (Throwable ex) {
            return "Unknown state " + error;
        }
    }

    private int bcdToInt(byte d) {
        return Integer.parseInt(String.format("%02x", d));
    }

    private String bcdToString(byte[] d) {
        StringBuilder sb = new StringBuilder();
        for (byte b : d) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

