/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds.search;

import java.io.IOException;
import ru.softlogic.hardware.bvr.ebds.Api;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Searchable
extends BaseSearchable {
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        Api api = new Api(port, this.log);
        api.getConnector().setAttempts(1);
        api.getConnector().setAttemptsPause(3);
        api.getConnector().setAttemptsTimeout(400);
        try {
            api.open();
            api.getAccessorType();
            api.getAccessorSerialNumber();
            DeviceDescription deviceDescription = null;
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            api.close();
        }
    }

    public SerialParams[] getSearchParams(int priority) {
        if (priority == 0) {
            return new SerialParams[]{new SerialParams(9600, DataBits.Seven, StopBits.One, Parity.Even)};
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 49;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 3);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }
}

