/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EbdsVersion {
    private final String version;
    private Product product;
    private int cassetteSize;
    private int billPathWidth;
    private Interface comInterface;

    public EbdsVersion(String version) {
        this.version = version;
        this.parse(version.toUpperCase());
    }

    private void parse(String version) {
        Pattern pattern = Pattern.compile("(SCN|SC)(|M|L|XL)(\\d{2})(\\d{1})(\\d{1})(\\w*)");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            String comInterfaceCode;
            String productCode = matcher.group(1);
            this.product = "SC".equals(productCode) ? Product.SC : ("SCN".equals(productCode) ? Product.SC_ADVANCE : Product.UNKNOWN);
            String cassetteCode = matcher.group(2);
            this.cassetteSize = "".equals(cassetteCode) ? 600 : ("M".equals(cassetteCode) ? 900 : ("L".equals(cassetteCode) ? 1200 : ("XL".equals(cassetteCode) ? 2000 : 0)));
            String billPathWidthCode = matcher.group(3);
            if (!billPathWidthCode.isEmpty()) {
                try {
                    this.billPathWidth = Integer.parseInt(billPathWidthCode);
                }
                catch (NumberFormatException ex) {
                    this.billPathWidth = 0;
                }
            }
            this.comInterface = "1".equals(comInterfaceCode = matcher.group(5)) ? Interface.RS_485 : ("2".equals(comInterfaceCode) ? Interface.OI_WHITH_NETPLEX_HARNESS : ("4".equals(comInterfaceCode) ? Interface.OI_WHITH_EBDS_HARNESS : ("7".equals(comInterfaceCode) ? Interface.RS_232 : ("8".equals(comInterfaceCode) ? Interface.RS_USB : Interface.UNKNOWN))));
        }
    }

    public Product getProduct() {
        return this.product;
    }

    public Interface getComInterface() {
        return this.comInterface;
    }

    public int getCassetteSize() {
        return this.cassetteSize;
    }

    public int getBillPathWidth() {
        return this.billPathWidth;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "EdbsVersion{version=" + this.version + ", product=" + (Object)((Object)this.product) + ", cassetteSize=" + this.cassetteSize + ", billPathWidth=" + this.billPathWidth + ", comInterface=" + (Object)((Object)this.comInterface) + '}';
    }

    public static enum Interface {
        RS_485,
        OI_WHITH_NETPLEX_HARNESS,
        OI_WHITH_EBDS_HARNESS,
        RS_232,
        RS_USB,
        UNKNOWN;

    }

    public static enum Product {
        SC,
        SC_ADVANCE,
        UNKNOWN;

    }
}

