/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds;

import java.util.Arrays;
import ru.softlogic.io.utils.BU;

public class EbdsStatus {
    private final byte[] data;
    private final byte[] extendedData;

    public EbdsStatus(byte[] data, byte[] extendedData) {
        if (data == null || data.length != 7) {
            throw new IllegalArgumentException("Data must be a length of 7 bytes, but recv: " + BU.toString((byte[])data));
        }
        this.data = data;
        this.extendedData = extendedData;
    }

    public boolean isIdling() {
        return (this.data[1] & 1) != 0;
    }

    public boolean isOnlyIdling() {
        return this.data[1] == 1;
    }

    public boolean isAccepting() {
        return (this.data[1] & 2) != 0;
    }

    public boolean isEscrowed() {
        return (this.data[1] & 4) != 0;
    }

    public boolean isStacking() {
        return (this.data[1] & 8) != 0;
    }

    public boolean isStacked() {
        return (this.data[1] & 0x10) != 0 && this.extendedData != null && !this.isExtNull();
    }

    public boolean isReturning() {
        return (this.data[1] & 0x20) != 0;
    }

    public boolean isReturned() {
        return (this.data[1] & 0x40) != 0;
    }

    public boolean isCheated() {
        return (this.data[2] & 1) != 0;
    }

    public boolean isRejected() {
        return (this.data[2] & 2) != 0;
    }

    public boolean isJammed() {
        return (this.data[2] & 4) != 0;
    }

    public boolean isStackerFull() {
        return (this.data[2] & 8) != 0;
    }

    public boolean isCassetteAttached() {
        return (this.data[2] & 0x10) != 0;
    }

    public boolean isPaused() {
        return (this.data[2] & 0x20) != 0;
    }

    public boolean isCalibration() {
        return (this.data[2] & 0x40) != 0;
    }

    public boolean isPowerUp() {
        return (this.data[3] & 1) != 0;
    }

    public boolean isInvalidCommand() {
        return (this.data[3] & 2) != 0;
    }

    public boolean isFailure() {
        return (this.data[3] & 4) != 0;
    }

    public int getBillCode() {
        return (this.data[3] & 0xF8) >> 3;
    }

    public byte[] getExtendedData() {
        return this.extendedData;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isFlashDownload() {
        return (this.data[4] & 2) != 0;
    }

    public String toString() {
        return "EbdsStatus{data=" + BU.toString((byte[])this.data) + ", ext=" + BU.toString((byte[])this.extendedData) + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EbdsStatus other = (EbdsStatus)obj;
        for (int i = 1; i < this.data.length; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return (this.data[0] & 0xFE) == (other.data[0] & 0xFE);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    private boolean isExtNull() {
        if (this.extendedData != null) {
            for (byte b : this.extendedData) {
                if (b == 0) continue;
                return false;
            }
        }
        return true;
    }
}

