/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.ebds.Connector;
import ru.softlogic.hardware.bvr.ebds.EbdsStatus;
import ru.softlogic.hardware.bvr.ebds.Note;
import ru.softlogic.hardware.bvr.ebds.Reply;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class Api {
    private final SerialPort port;
    private final Connector conn;
    private final byte[] data;
    private final Logger log;
    private boolean enable = false;

    public Api(SerialPort port, Logger log) {
        this.conn = new Connector(port, log);
        this.port = port;
        this.log = log;
        this.data = new byte[3];
        this.data[0] = 0;
        this.data[1] = 28;
        this.data[2] = 16;
    }

    public void enable() throws IOException {
        if (this.data[0] == 0) {
            this.data[0] = -1;
            this.sendExtendedMessage(3, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        }
        this.enable = true;
    }

    public void disable() throws IOException {
        if (this.data[0] != 0) {
            this.data[0] = 0;
            this.sendExtendedMessage(3, new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        }
        this.enable = false;
    }

    public void unsetCashPolicy() {
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFDF);
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFBF);
    }

    public void stackCash() throws IOException {
        this.data[1] = (byte)(this.data[1] | 0x20);
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFBF);
        this.sendOmnibusMessage();
    }

    public void returnCash() throws IOException {
        this.data[1] = (byte)(this.data[1] | 0x40);
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFDF);
        this.sendOmnibusMessage();
    }

    public EbdsStatus poll() throws IOException {
        return this.sendOmnibusMessage();
    }

    public String getAccessorType() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 4}, null);
        return this.parceAns(ans, 21);
    }

    public String getAccessorSerialNumber() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 5}, null);
        return this.parceAns(ans, 21);
    }

    public int queryDeviceResets() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 2}, null);
        this.log.info((Object)("counts=" + BU.toString((byte[])ans)));
        if (ans.length < 7) {
            throw new IOException("Wrong answer lenght: " + BU.toString((byte[])ans));
        }
        return ((ans[1] & 0xF) << 20) + ((ans[2] & 0xF) << 16) + ((ans[3] & 0xF) << 12) + ((ans[4] & 0xF) << 8) + ((ans[5] & 0xF) << 4) + (ans[6] & 0xF);
    }

    public String getAccessorBootPartNumner() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 6}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorApplicationPartNumber() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 7}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorApplicationId() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 14}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorVariant() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 8}, null);
        return this.parceAns(ans, 33);
    }

    public String getAccessorVariantId() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 15}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorVariantPart() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 9}, null);
        return this.parceAns(ans, 10);
    }

    public Note getNoteDescription(int id) throws IOException {
        if (id < 1 || id > 50) {
            throw new IllegalArgumentException("id must be in 1..255");
        }
        byte[] res = this.sendExtendedMessage(2, new byte[]{(byte)id}).getExtendedData();
        return this.createNote(res);
    }

    public void reset() throws IOException {
        this.conn.onlySendCommand(96, new byte[]{127, 127, 127}, 5000);
    }

    public void hdwStatus() throws IOException {
        byte[] res = this.conn.sendCommand(96, new byte[]{0, 0, 35}, 5000);
        this.log.info((Object)("hdwStatus = " + BU.toString((byte[])res)));
    }

    private EbdsStatus sendOmnibusMessage() throws IOException {
        byte[] res = this.conn.sendCommand(16, this.data, null);
        return this.parceAnswer(res);
    }

    public boolean isDownloadMode() throws IOException {
        Reply reply = this.conn.sendCommand(16, this.data, true, null);
        this.log.info((Object)("Check download mode reply: " + reply));
        return reply.getData().length == 5 && reply.getData()[0] == 80;
    }

    private EbdsStatus sendExtendedMessage(int subType, byte[] extendedData) throws IOException {
        byte[] request = new byte[4 + extendedData.length];
        request[0] = (byte)subType;
        System.arraycopy(this.data, 0, request, 1, this.data.length);
        System.arraycopy(extendedData, 0, request, 4, extendedData.length);
        byte[] res = this.conn.sendCommand(112, request, null);
        return this.parceAnswer(res);
    }

    private EbdsStatus parceAnswer(byte[] res) {
        if ((res[0] & 0xF0) == 32) {
            return new EbdsStatus(res, null);
        }
        this.log.info((Object)("Ext message: " + BU.toString((byte[])res)));
        byte[] resData = new byte[7];
        resData[0] = res[0];
        System.arraycopy(res, 2, resData, 1, resData.length - 1);
        byte[] resDataExt = new byte[res.length - 8];
        System.arraycopy(res, 8, resDataExt, 0, resDataExt.length);
        return new EbdsStatus(resData, resDataExt);
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void debugData(byte[] data) {
        if (data == null || data.length != 7) {
            throw new IllegalArgumentException("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 7 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        this.log.info((Object)(((data[1] & 1) != 0 ? "*idl" : "-idl") + " " + ((data[1] & 2) != 0 ? "*acc" : "-acc") + " " + ((data[1] & 4) != 0 ? "*esc" : "-esc") + " " + ((data[1] & 8) != 0 ? "*stg" : "-stg") + " " + ((data[1] & 0x10) != 0 ? "*std" : "-std") + " " + ((data[1] & 0x20) != 0 ? "*rtg" : "-rtg") + " " + ((data[1] & 0x40) != 0 ? "*rtd" : "-rtd") + "|" + ((data[2] & 1) != 0 ? "*che" : "-che") + " " + ((data[2] & 2) != 0 ? "*rej" : "-rej") + " " + ((data[2] & 4) != 0 ? "*jam" : "-jam") + " " + ((data[2] & 8) != 0 ? "*ful" : "-ful") + " " + ((data[2] & 0x10) != 0 ? "*att" : "-att") + " " + ((data[2] & 0x20) != 0 ? "*psd" : "-psd") + " " + ((data[2] & 0x40) != 0 ? "*cal" : "-cal") + "|" + ((data[3] & 1) != 0 ? "*pow" : "-pow") + " " + ((data[3] & 2) != 0 ? "*inv" : "-inv") + " " + ((data[3] & 4) != 0 ? "*fal" : "-fal") + "| hex=" + BU.toString((byte[])data)));
    }

    public void debugData2(byte[] data) {
        if (data == null || data.length != 7) {
            throw new IllegalArgumentException("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 7 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        this.log.info((Object)"-------------------------------");
        if ((data[1] & 1) != 0) {
            this.log.info((Object)"* Idling");
        } else {
            this.log.info((Object)"- Idling");
        }
        if ((data[1] & 2) != 0) {
            this.log.info((Object)"* Accepting");
        } else {
            this.log.info((Object)"- Accepting");
        }
        if ((data[1] & 4) != 0) {
            this.log.info((Object)"* Escrowed");
        } else {
            this.log.info((Object)"- Escrowed");
        }
        if ((data[1] & 8) != 0) {
            this.log.info((Object)"* Stacking");
        } else {
            this.log.info((Object)"- Stacking");
        }
        if ((data[1] & 0x10) != 0) {
            this.log.info((Object)"* Stacked");
        } else {
            this.log.info((Object)"- Stacked");
        }
        if ((data[1] & 0x20) != 0) {
            this.log.info((Object)"* Returning");
        } else {
            this.log.info((Object)"- Returning");
        }
        if ((data[1] & 0x40) != 0) {
            this.log.info((Object)"* Returned");
        } else {
            this.log.info((Object)"- Returned");
        }
        this.log.info((Object)"-------------------------------");
        if ((data[2] & 1) != 0) {
            this.log.info((Object)"* Cheated");
        } else {
            this.log.info((Object)"- Cheated");
        }
        if ((data[2] & 2) != 0) {
            this.log.info((Object)"* Rejected");
        } else {
            this.log.info((Object)"- Rejected");
        }
        if ((data[2] & 4) != 0) {
            this.log.info((Object)"* Jammed");
        } else {
            this.log.info((Object)"- Jammed");
        }
        if ((data[2] & 8) != 0) {
            this.log.info((Object)"* Stacker Full");
        } else {
            this.log.info((Object)"- Stacker Full");
        }
        if ((data[2] & 0x10) != 0) {
            this.log.info((Object)"* Cassette Attached");
        } else {
            this.log.info((Object)"- Cassette Attached");
        }
        if ((data[2] & 0x20) != 0) {
            this.log.info((Object)"* Paused");
        } else {
            this.log.info((Object)"- Paused");
        }
        if ((data[2] & 0x40) != 0) {
            this.log.info((Object)"* Calib in progress");
        } else {
            this.log.info((Object)"- Calibration in progress");
        }
        this.log.info((Object)"-------------------------------");
        if ((data[3] & 1) != 0) {
            this.log.info((Object)"* Power Up");
        } else {
            this.log.info((Object)"- Power Up");
        }
        if ((data[3] & 2) != 0) {
            this.log.info((Object)"* Invalid Command");
        } else {
            this.log.info((Object)"- Invalid Command");
        }
        if ((data[3] & 4) != 0) {
            this.log.info((Object)"* Failure");
        } else {
            this.log.info((Object)"- Failure");
        }
        this.log.info((Object)"-------------------------------");
        this.log.info((Object)("Bill Value " + ((data[3] & 0xF8) >> 3)));
    }

    private String parceAns(byte[] ans, int len) {
        if (ans.length == len) {
            String res = "";
            for (int i = 1; i < ans.length; ++i) {
                char symbol = (char)ans[i];
                if (!Character.isLetterOrDigit(symbol)) continue;
                res = res + symbol;
            }
            return res;
        }
        this.log.error((Object)("Wrong ans=" + BU.toString((byte[])ans)));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len - 1; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    public Note createNote(byte[] data) {
        if (data[2] == 0) {
            return null;
        }
        try {
            return new Note(data[0], new String(data, 1, 3), Integer.parseInt(new String(data, 4, 3)), Integer.parseInt(new String(data, 7, 3).replace("+", "")));
        }
        catch (NumberFormatException ex) {
            this.log.error((Object)("Error on parce note description: " + BU.toString((byte[])data)), (Throwable)ex);
            return null;
        }
    }

    public Connector getConnector() {
        return this.conn;
    }

    public boolean startDownloadFirmware() throws IOException {
        this.log.info((Object)"Initial poll for download process");
        Reply res = this.conn.sendCommand(16, new byte[]{0, 0, 0}, true, null);
        this.log.info((Object)("Reply: " + res));
        if (res.getData()[0] == 80) {
            return true;
        }
        this.log.info((Object)"Start download");
        EbdsStatus status = new EbdsStatus(this.conn.sendCommand(80, new byte[]{0, 0, 16}, 1500), null);
        this.log.info((Object)("Reply: " + res));
        this.log.info((Object)("Download mode: " + status.isFlashDownload()));
        return status.isFlashDownload();
    }

    public boolean finishDownloadFirmware() throws IOException {
        byte[] res = this.conn.sendCommand(16, new byte[]{0, 0, 0}, 1500);
        return res != null && (res[0] & 0xF0) == 32;
    }

    public int blockDownloadFirmware(int blockNumber, byte[] data) throws IOException {
        if (data == null || data.length != 32) {
            throw new IllegalArgumentException("Data size must be equal to 32 bytes");
        }
        if (blockNumber < 0 || blockNumber > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Block number must be in range 0..32767");
        }
        byte[] blockData = new byte[data.length * 2 + 4];
        blockData[0] = BU.c((int)(blockNumber >> 12 & 0xF));
        blockData[1] = BU.c((int)(blockNumber >> 8 & 0xF));
        blockData[2] = BU.c((int)(blockNumber >> 4 & 0xF));
        blockData[3] = BU.c((int)(blockNumber & 0xF));
        for (int i = 0; i < data.length; ++i) {
            blockData[4 + 2 * i + 0] = BU.c((int)(data[i] >> 4 & 0xF));
            blockData[4 + 2 * i + 1] = BU.c((int)(data[i] & 0xF));
        }
        Reply res = this.conn.sendCommand(80, blockData, true, 300);
        if (!res.isNak()) {
            return blockNumber + 1;
        }
        this.log.error((Object)("Error reply: " + res));
        this.conn.reverseFlag();
        byte[] reply = res.getData();
        int retryBlockNumber = ((reply[1] & 0xF) << 12) + ((reply[2] & 0xF) << 8) + ((reply[3] & 0xF) << 4) + ((reply[4] & 0xF) + 1) & 0xFFFF;
        return retryBlockNumber;
    }

    public int fastBlockDownloadFirmware(int blockNumber, byte[] data) throws IOException {
        if (data == null || data.length != 32 && data.length != 64) {
            throw new IllegalArgumentException("Data size must be equal to 32 or 64 bytes");
        }
        if (blockNumber < 0 || blockNumber > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Block number must be in range 0..32767");
        }
        byte[] blockData = new byte[data.length + 2];
        blockData[1] = BU.c((int)(blockNumber >> 8 & 0xFF));
        blockData[0] = BU.c((int)(blockNumber & 0xFF));
        System.arraycopy(data, 0, blockData, 2, data.length);
        Reply res = this.conn.sendCommand(80, blockData, true, 300);
        if (!res.isNak()) {
            return blockNumber + 1;
        }
        byte[] b = res.getData();
        return (BU.c((byte)b[2]) << 8 | BU.c((byte)b[1])) + 1;
    }

    public SerialParams setMaxBaudRate() {
        try {
            this.log.info((Object)"Try to select speed 4");
            Reply r = this.conn.sendCommand(80, new byte[]{4}, false, 500);
            this.log.info((Object)("Result: " + r));
            if (r.getData().length == 2 && r.getData()[0] == 80) {
                if (r.isNak()) {
                    this.log.info((Object)("Try to select speed " + r.getData()[1]));
                    r = this.conn.sendCommand(80, new byte[]{r.getData()[1]}, false, 500);
                    this.log.info((Object)("Result: " + r));
                }
                if (!r.isNak() && r.getData()[1] > 0) {
                    int[] speeds = new int[]{9600, 19200, 38400, 115200};
                    return new SerialParams(speeds[r.getData()[1] - 1], DataBits.Eight, StopBits.One, Parity.None);
                }
                this.log.error((Object)"Wrong speed id or NAK");
            } else {
                this.log.error((Object)"Wrong answer format");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public SerialPort getPort() {
        return this.port;
    }
}

