/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ccnet.search;

import java.io.IOException;
import ru.softlogic.hardware.bvr.ccnet.Api;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Searchable
extends BaseSearchable {
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        Api api = new Api(port, this.log);
        api.getConnector().setAttempts(1);
        api.getConnector().setAttemptsTimeout(0);
        try {
            api.open();
            api.search();
            DeviceDescription deviceDescription = null;
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            api.close();
        }
    }

    public SerialParams[] getSearchParams(int priority) {
        switch (priority) {
            case 0: {
                return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
            }
            case 1: {
                return new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)};
            }
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 45;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 1);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }
}

