/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ccnet;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.ccnet.BillType;
import ru.softlogic.hardware.bvr.ccnet.CcnetInfo;
import ru.softlogic.hardware.bvr.ccnet.CcnetStatus;
import ru.softlogic.hardware.bvr.ccnet.Connector;
import ru.softlogic.hdw.WrongCommandException;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public final class Api {
    private final Connector conn;

    public Api(SerialPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.conn = new Connector(port, log);
    }

    public void open() throws IOException {
        this.conn.open();
    }

    public void close() {
        this.conn.close();
    }

    public void reset() throws IOException {
        this.conn.sendCommand((byte)48);
    }

    public BillType[] billTable() throws IOException {
        byte[] data = this.conn.sendCommand((byte)65);
        if (data.length != 120) {
            throw new IOException("Data size must have 120 byte length");
        }
        LinkedList<BillType> table = new LinkedList<BillType>();
        for (int i = 0; i < 24; ++i) {
            String currency;
            int nominal = data[i * 5] * (int)Math.pow(10.0, data[i * 5 + 4]);
            if (nominal <= 0 || (currency = "" + (char)data[i * 5 + 1] + (char)data[i * 5 + 2] + (char)data[i * 5 + 3]).equalsIgnoreCase("bar")) continue;
            table.add(new BillType(i, currency, nominal));
        }
        return table.toArray(new BillType[table.size()]);
    }

    public CcnetStatus poll() throws IOException {
        byte[] data = this.conn.sendCommand((byte)51);
        if (data.length < 1) {
            throw new IOException("Empty answer");
        }
        return new CcnetStatus(BU.c((byte)data[0]), data.length >= 2 ? BU.c((byte)data[1]) : 0);
    }

    public void search() throws IOException {
        this.conn.sendCommand((byte)51, 120);
    }

    public final int enable() throws IOException {
        byte mask = -1;
        byte[] data = new byte[]{mask, mask, mask, mask, mask, mask};
        byte[] res = this.conn.sendCommand((byte)52, data);
        return BU.c((byte)res[0]);
    }

    public final int disable() throws IOException {
        byte mask = 0;
        byte[] data = new byte[]{mask, mask, mask, mask, mask, mask};
        byte[] res = this.conn.sendCommand((byte)52, data);
        return BU.c((byte)res[0]);
    }

    public final void stackCash() throws IOException {
        this.conn.sendCommand((byte)53);
    }

    public final void returnCash() throws IOException {
        this.conn.sendCommand((byte)54);
    }

    public final CcnetInfo identification() throws IOException {
        String firmware;
        String model;
        byte[] data = this.conn.sendCommand((byte)55);
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < data.length - 7; ++i) {
            char symbol = (char)data[i];
            if (i < 15) {
                sb1.append(BU.isStringChar((char)symbol) ? symbol : (char)' ');
                continue;
            }
            sb2.append(BU.isStringChar((char)symbol) ? symbol : (char)' ');
        }
        String pn = sb1.toString().trim();
        if (pn.contains("-")) {
            int pos = pn.indexOf(45);
            model = pn.substring(0, pos);
            firmware = pn.substring(pos + 1);
        } else {
            model = firmware = pn;
        }
        return new CcnetInfo(model, firmware, pn, sb2.toString().trim());
    }

    public final byte[] getStatus() throws IOException {
        return this.conn.sendCommand((byte)49);
    }

    public boolean updateStart() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, null, false, 3000);
        return data != null && data.length != 0 && data[0] == 0;
    }

    public int getUpdateStatus() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, new byte[]{0}, false);
        return BU.c((byte)data[0]);
    }

    public byte getBlockSize() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, new byte[]{1}, false);
        return data[0];
    }

    public int writeUpdating(byte[] block) throws IOException {
        byte[] respose = this.conn.sendCommand((byte)80, block, false, 3000);
        return BU.c((byte)respose[0]);
    }

    public int updateEnd() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, new byte[]{3}, false);
        return BU.c((byte)data[0]);
    }

    public boolean isDownloadMode() throws IOException {
        try {
            this.conn.sendCommandEx((byte)49, null, true, null);
            return false;
        }
        catch (WrongCommandException ex) {
            return this.getBlockSize() != 0;
        }
    }

    public Connector getConnector() {
        return this.conn;
    }
}

