/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bar.generic.driver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bar.BaseDriver;
import ru.softlogic.hdw.dev.barcode.BarOptions;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;
import ru.softlogic.io.utils.SerialFmt;

public class Driver
extends BaseDriver {
    private final SerialPort port;
    private final Logger log;
    private final BarOptions options;

    public Driver(String type, SerialPort port, BarOptions options, Logger log) {
        super(type, port, options, log);
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (options == null) {
            throw new NullPointerException("BarcodeScannerOptions is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.port = port;
        this.options = options;
        this.log = log;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Device type: " + this.getDeviceId().getType()));
        this.log.info((Object)("Serial params: " + SerialFmt.format((SerialPort)this.port)));
        this.updateDeviceInfo(this.createDeviceInfo());
        this.updateState(0);
        StringBuilder sb = new StringBuilder();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try {
                    if (!this.port.isOpen()) {
                        this.port.open();
                    }
                    if (this.port.avaliable() > 0) {
                        byte[] data = this.port.read(this.port.avaliable());
                        this.log.debug((Object)("<<" + BU.toString((byte[])data)));
                        String str = new String(data, StandardCharsets.UTF_8);
                        int index = str.indexOf(this.options.getStop());
                        if (index < 0) {
                            sb.append(str);
                        } else if (index == str.length() - 1) {
                            sb.append(str);
                            this.notifyBarcode(sb.toString().trim());
                            sb = new StringBuilder();
                        } else {
                            sb.append(str.substring(0, index));
                            this.notifyBarcode(sb.toString().trim());
                            sb = new StringBuilder(str.substring(index + 1));
                        }
                    } else {
                        this.sleep(100);
                    }
                    this.onConnSuccess();
                }
                catch (IOException ex) {
                    this.onConnError(ex);
                    this.port.close();
                    this.sleep(1000);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.port.close();
        this.log.info((Object)"Stop thread");
    }
}

