/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bar;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.barcode.BarOptions;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.hdw.dev.barcode.BarcodeScanner;
import ru.softlogic.hdw.dev.barcode.BarcodeScannerDriver;
import ru.softlogic.hdw.dev.barcode.Control;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public abstract class BaseDriver
extends BaseDevice
implements BarcodeScanner,
BarcodeScannerDriver,
Runnable {
    private static final String BASE_VERSION = "c2.0.0";
    private final Set<BarcodeListener> listeners = new HashSet<BarcodeListener>();
    private final SerialPort port;
    private final Logger log;
    private final List<Thread> threads = new LinkedList<Thread>();
    private final BarOptions options;

    public BaseDriver(String type, SerialPort port, BarOptions options, Logger log) {
        super(new DeviceId(10, type, 0), BASE_VERSION, log);
        this.port = port;
        this.log = log;
        this.options = options;
        this.threads.add(new Thread((Runnable)this, "drv(" + type + ")"));
    }

    public void addBarcodeListener(BarcodeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeBarcodeListener(BarcodeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.listeners.remove(listener);
    }

    protected void notifyBarcode(String barcode) {
        this.log.info((Object)("Notify " + barcode));
        for (BarcodeListener bl : this.listeners) {
            bl.onBarcode(barcode);
        }
    }

    public BarcodeScanner getBarcodeScanner() {
        return this;
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    public Control getControl() {
        return null;
    }

    protected DeviceInfo createDeviceInfo() {
        DeviceId did = this.getDeviceId();
        DeviceInfo di = new DeviceInfo(did.getDeviceClass(), did.getType());
        di.setPort(SerialFmt.format((SerialPort)this.port));
        return di;
    }
}

