/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.ioc.cio20.api;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.io.StopStorage;
import ru.softlogic.io.Storage;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

class Connector {
    private final SerialPort sp;
    private final Logger log;
    private int attempts;
    private int timeout;

    public Connector(SerialPort sp, Logger log) {
        this.sp = sp;
        this.log = log;
        this.timeout = 1000;
        this.attempts = 3;
    }

    public void setAttempts(int attempts) {
        if (attempts < 0 || attempts > 10) {
            throw new IllegalArgumentException("Params 'attempts' is invalid");
        }
        this.attempts = attempts;
    }

    public void setTimeout(int defaultTimeout) {
        if (this.timeout < 0 || this.timeout > 10000) {
            throw new IllegalArgumentException("Params 'timeout' is invalid");
        }
        this.timeout = defaultTimeout;
    }

    public synchronized void open() throws IOException {
        this.sp.open();
    }

    public synchronized void close() throws IOException {
        this.sp.close();
    }

    public synchronized String sendRequest(String request) throws IOException {
        this.sp.setTimeout(this.timeout);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.sp.flush(Flush.RxTx);
                this.sp.write((request + '\r').getBytes());
                byte[] read = this.sp.read((Storage)new StopStorage(13));
                return new String(read).trim();
            }
            catch (IOException ex) {
                this.log.error((Object)ex.getMessage());
                if (i != this.attempts - 1) continue;
                throw ex;
            }
        }
        throw new IOException();
    }
}

