/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.ioc.cio20.api;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.ioc.cio20.api.Connector;
import ru.softlogic.hdw.dev.ioc.IOControllerException;
import ru.softlogic.io.serial.SerialPort;

public class Api {
    private static final String RESULT_OK = "OK";
    private final Connector conn;
    private final Logger log;

    public Api(SerialPort sp, Logger log) {
        this.conn = new Connector(sp, log);
        this.log = log;
    }

    public void open() throws IOException {
        this.conn.open();
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAttempts(int attempts) {
        this.conn.setAttempts(attempts);
    }

    public void setTimeout(int defaultTimeout) {
        this.conn.setTimeout(defaultTimeout);
    }

    public String getName() throws IOException {
        this.log.debug((Object)"Execute command 'name?'");
        String result = this.conn.sendRequest("name?");
        this.log.debug((Object)("    Result: " + result));
        return result;
    }

    public int inputsInfo() throws IOControllerException {
        try {
            int result = this.executeInfoCommand("inputs");
            return result;
        }
        catch (IOException ex) {
            throw new IOControllerException((Throwable)ex);
        }
    }

    public int outputsInfo() throws IOControllerException {
        try {
            this.log.debug((Object)"Execute command 'outputs?'");
            int result = this.executeInfoCommand("outputs");
            this.log.debug((Object)("    Result: " + Integer.toBinaryString(result)));
            return result;
        }
        catch (IOException ex) {
            throw new IOControllerException((Throwable)ex);
        }
    }

    public void outs(boolean state) throws IOControllerException {
        this.log.debug((Object)("Execute command 'outs?', state=" + state));
        try {
            String result = this.conn.sendRequest("outs=" + (state ? "11111111111111111111" : "00000000000000000000"));
            this.log.debug((Object)("    Result: " + result));
            if (!result.equals(RESULT_OK)) {
                throw new IOControllerException("Error executing the command");
            }
        }
        catch (IOException ex) {
            throw new IOControllerException((Throwable)ex);
        }
    }

    public void outNN(int line, boolean state) throws IOControllerException {
        try {
            this.log.debug((Object)("Execute command 'outNN?', line=" + line + ", state=" + state));
            String result = this.conn.sendRequest("out" + String.format("%02d", line) + "=" + (state ? "1" : "0"));
            this.log.debug((Object)("    Result: " + result));
            if (!result.equals(RESULT_OK)) {
                throw new IOControllerException("Error executing the command");
            }
        }
        catch (IOException ex) {
            throw new IOControllerException((Throwable)ex);
        }
    }

    public void autodetectin(boolean state) throws IOControllerException {
        try {
            this.log.debug((Object)("Execute command 'autodetectin?', state=" + state));
            String result = this.conn.sendRequest("autodetectin_" + (state ? "on" : "of"));
            this.log.debug((Object)("    Result: " + result));
            if (!result.equals(RESULT_OK)) {
                throw new IOControllerException("Error executing the command");
            }
        }
        catch (IOException ex) {
            throw new IOControllerException((Throwable)ex);
        }
    }

    private int executeInfoCommand(String command) throws IOException {
        String sendRequest = this.conn.sendRequest(command + "?");
        if (!sendRequest.startsWith(command + "=")) {
            throw new IOException("Wrong response: " + sendRequest);
        }
        return this.createBitMap(sendRequest.substring(command.length() + 1));
    }

    private int createBitMap(String strBitmap) {
        int result = 0;
        for (int i = 0; i < strBitmap.length(); ++i) {
            if (strBitmap.charAt(i) != '1') continue;
            result |= 1 << i;
        }
        return result;
    }

    public String getSerialNumber() throws IOControllerException {
        try {
            this.log.debug((Object)"Execute command 'sn?'");
            String result = this.conn.sendRequest("sn?");
            this.log.debug((Object)("    Result: " + result));
            if (result.startsWith("sn=")) {
                return result.substring(3);
            }
            return result;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

