/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io.utils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class BU {
    private static final String PRINTABLE = "/-:.,_$%\\()[]<> ";
    public static final int DEFAULT_LINESIZE = 32;

    public static String toStringEx(byte ... data) {
        if (data == null) {
            return "";
        }
        return BU.toStringEx(data, 0, data.length, 32);
    }

    public static String toStringEx(byte[] data, int lineSize) {
        if (data == null) {
            return "";
        }
        return BU.toStringEx(data, 0, data.length, lineSize);
    }

    public static String toStringEx(byte[] data, int offset, int len) {
        return BU.toStringEx(data, offset, len, 32);
    }

    public static String toStringEx(byte[] data, int offset, int len, int lineSize) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (i > 0 && i % lineSize == 0) {
                sb.append('\n');
            }
            sb.append(String.format("%02x", data[offset + i]));
        }
        return sb.toString();
    }

    public static String toStringEx(byte[] ... data) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int total = 0;
        for (byte[] arr : data) {
            for (int i = 0; i < arr.length; ++i) {
                if (total > 0 && total % 32 == 0) {
                    sb.append('\n');
                } else if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", arr[i]));
                ++total;
            }
        }
        return sb.toString();
    }

    public static byte[] union(byte[] ... data) {
        int len = 0;
        for (byte[] d : data) {
            len += d.length;
        }
        byte[] res = new byte[len];
        int start = 0;
        for (byte[] d : data) {
            System.arraycopy(d, 0, res, start, d.length);
            start += d.length;
        }
        return res;
    }

    public static byte[] getPiece(byte[] req, int offset) {
        return BU.getPiece(req, offset, req.length - offset);
    }

    public static byte[] getPiece(byte[] req, int offset, int length) {
        byte[] res = new byte[length];
        System.arraycopy(req, offset, res, 0, length);
        return res;
    }

    public static List<byte[]> split(byte[] data, int token) {
        if (data == null) {
            throw new NullPointerException("Data is null");
        }
        LinkedList<byte[]> res = new LinkedList<byte[]>();
        LinkedList<Byte> line = null;
        for (byte b : data) {
            if (BU.c(b) == token) {
                if (line != null) {
                    res.add(BU.convert(line));
                }
                line = new LinkedList<Byte>();
                continue;
            }
            if (line == null) {
                line = new LinkedList();
            }
            line.add(b);
        }
        res.add(BU.convert(line));
        return res;
    }

    public static byte c(int i) {
        return (byte)(i & 0xFF);
    }

    public static int c(byte i) {
        return i & 0xFF;
    }

    public static int csbe(byte[] data, int start) {
        return ((data[start] & 0xFF) << 8) + (data[start + 1] & 0xFF);
    }

    public static int csle(byte[] data, int start) {
        return ((data[start + 1] & 0xFF) << 8) + (data[start] & 0xFF);
    }

    public static int cibe(byte[] data, int start) {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            res += BU.c(data[start + i]);
        }
        return res;
    }

    public static int cile(byte[] data, int start) {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res += BU.c(data[start + i]) << i * 8;
        }
        return res;
    }

    public static long clbe(byte[] data, int start, int byteCount) {
        long res = 0L;
        for (int i = 0; i < byteCount; ++i) {
            res <<= 8;
            res += (long)BU.c(data[start + i]);
        }
        return res;
    }

    public static long clle(byte[] data, int start, int byteCount) {
        long res = 0L;
        for (int i = 0; i < byteCount; ++i) {
            res += (long)(data[start + i] & 0xFF) << i * 8;
        }
        return res;
    }

    public static void ssbe(byte[] data, int start, int value) {
        data[start] = BU.c(value >> 8 & 0xFF);
        data[start + 1] = BU.c(value & 0xFF);
    }

    public static void ssle(byte[] data, int start, int value) {
        data[start] = BU.c(value & 0xFF);
        data[start + 1] = BU.c(value >> 8 & 0xFF);
    }

    public static void sibe(byte[] data, int start, int value) {
        data[start] = BU.c(value >> 24 & 0xFF);
        data[start + 1] = BU.c(value >> 16 & 0xFF);
        data[start + 2] = BU.c(value >> 8 & 0xFF);
        data[start + 3] = BU.c(value & 0xFF);
    }

    public static void sile(byte[] data, int start, int value) {
        data[start] = BU.c(value & 0xFF);
        data[start + 1] = BU.c(value >> 8 & 0xFF);
        data[start + 2] = BU.c(value >> 16 & 0xFF);
        data[start + 3] = BU.c(value >> 24 & 0xFF);
    }

    public static void sile8(byte[] data, int start, long value) {
        for (int i = 0; i < 8; ++i) {
            data[start + i] = BU.c((int)(value >> 8 * i & 0xFFL));
        }
    }

    public static byte[] fill(int fillByte, int count) {
        byte[] res = new byte[count];
        for (int i = 0; i < count; ++i) {
            res[i] = BU.c(fillByte);
        }
        return res;
    }

    public static byte[] xor(byte[] arr1, byte[] arr2) {
        if (arr1 == null || arr2 == null) {
            throw new NullPointerException("Array is not set");
        }
        if (arr1.length != arr2.length) {
            throw new IllegalArgumentException("Diffrent sizes");
        }
        byte[] res = new byte[arr1.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = BU.c(arr1[i] ^ arr2[i]);
        }
        return res;
    }

    public static byte[] xor(byte[] arr1, byte[] arr2, int start2) {
        if (arr1 == null || arr2 == null) {
            throw new NullPointerException("Array is not set");
        }
        byte[] res = new byte[arr1.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = BU.c(arr1[i] ^ arr2[start2 + i]);
        }
        return res;
    }

    public static boolean isHexString(String data) {
        if (data == null || data.isEmpty()) {
            return false;
        }
        return (data = data.replace(" ", "").trim()).matches("[0-9a-fA-F]+") && data.length() % 2 == 0;
    }

    public static byte[] convertFromHex(String data) {
        String pData = data.replaceAll(" ", "");
        byte[] res = new byte[pData.length() / 2];
        for (int i = 0; i < pData.length() / 2; ++i) {
            res[i] = (byte)Integer.parseInt(pData.substring(i * 2, i * 2 + 2), 16);
        }
        return res;
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "";
        }
        String str = "";
        for (byte b : data) {
            str = str + String.format("%02X ", b);
        }
        return str;
    }

    public static String toString(List<Byte> data) {
        return BU.toStringEx(data);
    }

    public static String toStringEx(Collection<Byte> data) {
        if (data == null) {
            return "";
        }
        String str = "";
        for (byte b : data) {
            str = str + String.format("%02X ", b);
        }
        return str;
    }

    public static String toHex(int data) {
        return String.format("0x%02X ", data);
    }

    public static String toHex(byte data) {
        return String.format("0x%02X ", BU.c(data));
    }

    public static byte[] convert(List<Byte> data) {
        if (data == null) {
            return null;
        }
        byte[] res = new byte[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            res[i] = data.get(i);
        }
        return res;
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return "";
        }
        String str = "";
        for (byte b : data) {
            str = str + String.format("%02X", b);
        }
        return str;
    }

    public boolean isSet(byte data, int mask) {
        return (data & mask) > 0;
    }

    public static boolean isStringChar(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return true;
        }
        return PRINTABLE.indexOf(ch) >= 0;
    }

    public static String safeConvert(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char symbol = (char)data[i];
            sb.append(BU.isStringChar(symbol) ? symbol : (char)' ');
        }
        return sb.toString();
    }
}

