/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io.serial;

import java.io.IOException;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.PortBusyException;
import ru.softlogic.io.PortNotExistException;
import ru.softlogic.io.PortType;
import ru.softlogic.io.WrongTypePortException;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.StopBits;

public class SerialPort
extends BidirectionPort {
    private SerialParams params;

    public SerialPort(String name) {
        super(name);
        this.params = new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None);
    }

    public SerialPort(String name, SerialParams params) {
        super(name);
        if (params == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 \u043f\u043e\u0440\u0442\u0430");
        }
        this.params = params;
    }

    @Override
    public PortType getType() {
        return PortType.SerialPort;
    }

    @Override
    public void open() throws PortNotExistException, WrongTypePortException, PortBusyException, IOException {
        if (this.fd > 0) {
            throw new PortBusyException("Port already open by commlogic");
        }
        if (this.isOpen()) {
            throw new IllegalStateException("Port already open");
        }
        this.openNative(this.name);
        this.flush(Flush.RxTx);
        this.setParams(this.params);
        this.setFlow(Flow.None);
    }

    public void setParams(SerialParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialParams");
        }
        this.params = params;
        this.setParamsNative(params.getSpeed(), params.getDataBits().getCode(), params.getStopBits().getCode(), params.getParity().getCode());
    }

    public void setFlow(Flow flow) throws IOException {
        this.setFlowNative(flow.getCode());
    }

    @Override
    public void flush(Flush flush) throws IOException {
        this.flushNative(flush.getCode());
    }

    public void putParams(SerialParams params) {
        if (params == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialParams");
        }
        this.params = params;
    }

    public SerialParams getParams() {
        return this.params;
    }

    public void setRTS(boolean state) throws IOException {
        this.setRtsNative(state);
    }

    public void setDTR(boolean state) throws IOException {
        this.setDtrNative(state);
    }

    public boolean isCTS() throws IOException {
        return this.isCtsNative();
    }

    public boolean isRNG() throws IOException {
        return this.isRngNative();
    }

    public boolean isDSR() throws IOException {
        return this.isDsrNative();
    }

    private native void openNative(String var1) throws PortNotExistException, WrongTypePortException, PortBusyException, IOException;

    private native void setFlowNative(int var1) throws IOException;

    private native void setParamsNative(int var1, int var2, int var3, int var4) throws IOException;

    private native void setRtsNative(boolean var1) throws IOException;

    private native void setDtrNative(boolean var1) throws IOException;

    private native void flushNative(int var1) throws IOException;

    private native boolean isCtsNative() throws IOException;

    private native boolean isRngNative() throws IOException;

    private native boolean isDsrNative() throws IOException;

    public String toString() {
        return "SerialPort[name=" + this.name + ",params=" + this.params + ']';
    }

    @Override
    public String asStr() {
        return this.getName() + ":" + this.getParams();
    }
}

