/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io.serial;

import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.StopBits;

public class SerialParams {
    private final int speed;
    private final DataBits dataBits;
    private final StopBits stopBits;
    private final Parity parity;

    public SerialParams(int speed) {
        this(speed, DataBits.Eight, StopBits.One, Parity.None);
    }

    public SerialParams(int speed, DataBits dataBits, StopBits stopBits, Parity parity) {
        if (speed <= 0) {
            throw new IllegalArgumentException("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        if (dataBits == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DataBits");
        }
        if (stopBits == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 StopBits");
        }
        if (parity == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Parity");
        }
        this.speed = speed;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
    }

    public DataBits getDataBits() {
        return this.dataBits;
    }

    public Parity getParity() {
        return this.parity;
    }

    public int getSpeed() {
        return this.speed;
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }

    public String toString() {
        return Integer.toString(this.speed) + "," + this.dataBits.getName() + "," + this.stopBits.getName() + "," + (Object)((Object)this.parity);
    }
}

