/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Storage;
import ru.softlogic.io.utils.BU;

public class StopStorageEx
implements Storage {
    private final List<Byte> buf = new LinkedList<Byte>();
    private final List<byte[]> stops;
    private final int depth;

    public StopStorageEx(byte stop, int depth) {
        this(StopStorageEx.convert(stop), depth);
    }

    public StopStorageEx(byte[] stop, int depth) {
        this(StopStorageEx.convert(stop), depth);
    }

    public StopStorageEx(List<byte[]> stops, int depth) {
        if (stops == null || stops.isEmpty()) {
            throw new IllegalArgumentException("Stop chains is not found");
        }
        if (depth <= 0 || depth > 1024) {
            throw new IllegalArgumentException("Depth is wrong: " + depth + ", value must be in range [0..1024]");
        }
        this.stops = stops;
        this.depth = depth;
    }

    public StopStorageEx(byte stop) {
        this(stop, 255);
    }

    @Override
    public boolean add(byte b, BasePort port) throws IOException {
        this.buf.add(b);
        if (this.hasStop()) {
            return false;
        }
        if (this.buf.size() > this.depth) {
            throw new IOException("Can't find stop sequence, readed: " + BU.toString(this.buf));
        }
        return true;
    }

    @Override
    public byte[] getResult() {
        return BU.convert(this.buf);
    }

    private boolean hasStop() {
        for (byte[] rule : this.stops) {
            if (this.buf.size() < rule.length) continue;
            boolean found = true;
            for (int i = 0; i < rule.length; ++i) {
                if (rule[rule.length - 1 - i] == this.buf.get(this.buf.size() - 1 - i)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private static List<byte[]> convert(byte b) {
        LinkedList<byte[]> res = new LinkedList<byte[]>();
        res.add(new byte[]{b});
        return res;
    }

    private static List<byte[]> convert(byte[] bts) {
        LinkedList<byte[]> res = new LinkedList<byte[]>();
        res.add(bts);
        return res;
    }
}

