/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Storage;
import ru.softlogic.io.utils.BU;

public class StartStorageEx
implements Storage {
    private static final int DEFAULT_DEPTH = 24;
    private final List<Byte> res = new LinkedList<Byte>();
    private List<Byte> garbage;
    private final byte[] start;
    private final int needs;
    private final int depth;

    public StartStorageEx(byte[] start, int needs) {
        this(start, needs, 24);
    }

    public StartStorageEx(byte[] start, int needs, int depth) {
        if (start == null || start.length < 2 || start.length > 3) {
            throw new IllegalArgumentException("Start len must be in range 2..3");
        }
        if (needs < start.length) {
            throw new IllegalArgumentException("Count is wrong: " + needs + ", value must be equals or grear start len");
        }
        if (depth <= 0 || depth > 255) {
            throw new IllegalArgumentException("Depth is wrong: " + depth + ", value must be in range [0..255]");
        }
        this.start = start;
        this.needs = needs;
        this.depth = depth;
    }

    @Override
    public boolean add(byte b, BasePort port) throws IOException {
        this.res.add(b);
        while (!this.res.isEmpty() && !this.beginsWith()) {
            if (this.garbage == null) {
                this.garbage = new LinkedList<Byte>();
            }
            this.garbage.add(this.res.get(0));
            if (this.garbage.size() >= this.depth) {
                throw new IOException("Can't find start sequence, readed: " + BU.toString(this.garbage));
            }
            this.res.remove(0);
        }
        if (this.res.size() == this.start.length) {
            if (this.needs > this.start.length) {
                byte[] oth;
                for (byte o : oth = port.read(this.needs - this.res.size())) {
                    this.res.add(o);
                }
            }
            return false;
        }
        return true;
    }

    private boolean beginsWith() {
        for (int i = 0; i < this.res.size() && i < this.start.length; ++i) {
            if (this.res.get(i) == this.start[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] getResult() {
        return BU.convert(this.res);
    }
}

