/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Storage;
import ru.softlogic.io.utils.BU;

public class DoseStorage
implements Storage {
    private final int doseSize;
    private final int waitDuration;
    private final int totalTimeout;
    private final List<Byte> bytes = new LinkedList<Byte>();
    private Consumer consumer;

    public DoseStorage(int doseSize, int waitDuration, int totalTimeout, Consumer consumer) {
        this.doseSize = doseSize;
        this.waitDuration = waitDuration;
        this.totalTimeout = totalTimeout;
    }

    @Override
    public boolean add(byte b, BasePort port) throws IOException {
        this.bytes.add(b);
        if (this.bytes.size() == this.doseSize) {
            this.consumer.onDose(BU.convert(this.bytes));
            this.bytes.clear();
        }
        return true;
    }

    @Override
    public byte[] getResult() {
        return null;
    }

    public static interface Consumer {
        public void onDose(byte[] var1);
    }
}

