/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.utils;

import java.io.File;

public class MediaDetector {
    private static final String[] VIDEO = new String[]{".mp4", ".3g2", ".3gp", ".asf", ".avi", ".flv", ".mov", ".mpg", ".wmv", ".mpeg"};
    private static final String[] FLASH = new String[]{".swf"};
    private static final String[] IMAGE = new String[]{".jpg", ".gif", ".png", ".jpeg", ".bmp"};

    public static MediaType getMediaType(File file) {
        return MediaDetector.getMediaType(file.getAbsolutePath());
    }

    public static MediaType getMediaType(String filename) {
        if (MediaDetector.endsWith(filename, VIDEO)) {
            return MediaType.Video;
        }
        if (MediaDetector.endsWith(filename, FLASH)) {
            return MediaType.Flash;
        }
        if (MediaDetector.endsWith(filename, IMAGE)) {
            return MediaType.Image;
        }
        return MediaType.Unknown;
    }

    private static boolean endsWith(String name, String[] exts) {
        for (String ext : exts) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static enum MediaType {
        Video,
        Flash,
        Image,
        Unknown;

    }
}

