/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.player.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import org.apache.log4j.Logger;
import ru.softlogic.disig.player.netty.IncomingMessageListener;
import ru.softlogic.disig.player.netty.NettyListener;
import ru.softlogic.disig.player.netty.NettyStateHandler;
import ru.softlogic.disig.player.netty.WebSocketFrameHandler;

class WebSocketServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final String path;
    private final NettyListener nettyListener;
    private final IncomingMessageListener messageListener;
    private final Logger log = Logger.getLogger(WebSocketServerInitializer.class);

    public WebSocketServerInitializer(String path, NettyListener nettyListener, IncomingMessageListener messageListener) {
        this.path = path;
        this.nettyListener = nettyListener;
        this.messageListener = messageListener;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        this.log.info((Object)("Init " + ch));
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.path, null, true)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketFrameHandler(this.messageListener)});
        pipeline.addLast(new ChannelHandler[]{new NettyStateHandler(this.nettyListener)});
    }
}

