/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.player.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.log4j.Logger;
import ru.softlogic.disig.player.netty.IncomingMessageListener;

class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final IncomingMessageListener listener;
    private final Logger log = Logger.getLogger(WebSocketFrameHandler.class);

    public WebSocketFrameHandler(IncomingMessageListener listener) {
        this.listener = listener;
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof TextWebSocketFrame) {
            String request = ((TextWebSocketFrame)frame).text();
            this.listener.onMessage(request);
        } else {
            this.log.error((Object)("Unsupported frame type: " + frame.getClass().getName()));
        }
    }
}

