/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.player.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import org.apache.log4j.Logger;
import ru.softlogic.disig.player.netty.NettyListener;

class NettyStateHandler
extends ChannelInboundHandlerAdapter {
    private final NettyListener listener;
    private final Logger log = Logger.getLogger(NettyStateHandler.class);

    public NettyStateHandler(NettyListener listener) {
        if (listener == null) {
            throw new NullPointerException("NettyListener is null");
        }
        this.listener = listener;
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.log.info((Object)("Channel registered: " + ctx));
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log.info((Object)("Channel active: " + ctx));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error((Object)"Error in netty", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.log.info((Object)("Channel userEventTriggered: " + evt));
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            this.listener.onConnect(ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log.info((Object)"Channel channelInactive");
        this.listener.onDisconnect();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.log.info((Object)"Channel channelUnregistered");
    }
}

