/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.player.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.text.DateFormat;
import org.apache.log4j.Logger;
import ru.softlogic.disig.app.DiSigAppException;
import ru.softlogic.disig.info.Info;
import ru.softlogic.disig.player.BaseApplication;
import ru.softlogic.disig.player.PlayerStatus;
import ru.softlogic.disig.player.netty.IncomingMessageListener;
import ru.softlogic.disig.player.netty.NettyListener;
import ru.softlogic.disig.player.netty.WebSocketServerInitializer;

public class NettyApplication
extends BaseApplication
implements NettyListener,
IncomingMessageListener {
    private final int port;
    private final String path;
    private Channel serverChannel;
    private Channel clientChannel;
    private ServerBootstrap sb;
    private final Logger log = Logger.getLogger(NettyApplication.class);

    public NettyApplication(int port, String path) {
        if (port < 1000 || port > 65000) {
            throw new IllegalArgumentException("Port number must be in range 1000..65000");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path must be set");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must begin with /");
        }
        this.port = port;
        this.path = path;
        NioEventLoopGroup elg = new NioEventLoopGroup(1);
        this.sb = new ServerBootstrap();
        ((ServerBootstrap)this.sb.group((EventLoopGroup)elg).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketServerInitializer(path, this, this));
    }

    @Override
    public synchronized void start() throws DiSigAppException {
        NettyApplication.addHeader(this.log);
        this.log.info((Object)("Try to start on  127.0.0.1:" + this.port + this.path));
        this.notifyPlayerStatus(PlayerStatus.Launching);
        try {
            this.serverChannel = this.sb.bind(this.port).sync().channel();
            this.notifyPlayerStatus(PlayerStatus.Launched);
            this.log.info((Object)"Success");
        }
        catch (Throwable ex) {
            this.notifyPlayerStatus(PlayerStatus.Stopped);
            throw new DiSigAppException("Error on run application", ex);
        }
    }

    @Override
    public synchronized void stop() {
        this.log.info((Object)"Shutdown app");
        this.notifyPlayerStatus(PlayerStatus.Stopping);
        if (this.serverChannel != null && this.serverChannel.isOpen()) {
            this.serverChannel.close();
        }
        this.notifyPlayerStatus(PlayerStatus.Stopped);
        this.log.info((Object)"Done");
    }

    @Override
    public void onConnect(Channel channel) {
        this.clientChannel = channel;
        this.notifyPlayerStatus(PlayerStatus.Connected);
    }

    @Override
    public void onDisconnect() {
        this.clientChannel = null;
        this.notifyPlayerStatus(PlayerStatus.Launched);
    }

    @Override
    protected void sendMessage(String json) {
        this.log.info((Object)(">> " + json));
        this.clientChannel.writeAndFlush((Object)new TextWebSocketFrame(json));
    }

    @Override
    public void onMessage(String message) {
        this.onIncomingMessage(message);
    }

    private static void addHeader(Logger log) {
        log.info((Object)"***************************************************************************");
        log.info((Object)"*  Digital signage player                                                 *");
        log.info((Object)"*  The application was designed and developed by Soft-logic, Russia, 2017 *");
        log.info((Object)"*  More information on our website http://paylogic-software.com/          *");
        log.info((Object)"*  E-mail address for questions and suggestions: info@soft-logic.ru       *");
        log.info((Object)"***************************************************************************");
        log.info((Object)("Version: " + Info.getVersion()));
        log.info((Object)("Build date: " + DateFormat.getDateTimeInstance(3, 3).format(Info.getBuildTime())));
        log.info((Object)("CSV revision: " + Info.getCommit()));
        log.info((Object)"");
    }
}

