/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.player;

import java.io.File;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.softlogic.disig.player.Format;
import ru.softlogic.disig.player.Movie;
import ru.softlogic.disig.player.PlayerListener;
import ru.softlogic.disig.player.Playlist;
import ru.softlogic.disig.player.Plugin;
import ru.softlogic.disig.player.Screen;
import ru.softlogic.disig.player.SystemInfo;
import ru.softlogic.disig.player.SystemListener;

public class JSonProcessor {
    private static final String TYPE = "type";
    private static final String OBJECT = "obj";
    private static final String DURATION = "duration";
    private static final String ID = "id";
    private static final String URL = "url";
    private final Set<PlayerListener> playerListeners;
    private final Set<SystemListener> systemListeners;
    private final Logger log = Logger.getLogger(JSonProcessor.class);

    public JSonProcessor(Set<PlayerListener> playerListeners, Set<SystemListener> systemListeners) {
        this.playerListeners = playerListeners;
        this.systemListeners = systemListeners;
    }

    public String toJson(Playlist playList) {
        JSONObject o = new JSONObject();
        o.put(TYPE, (Object)"playlist");
        JSONObject pl = new JSONObject();
        JSONArray array = new JSONArray();
        for (Movie m : playList.getMovies()) {
            array.put((Object)this.convert(m));
        }
        pl.put("movies", (Object)array);
        o.put(OBJECT, (Object)pl);
        return o.toString();
    }

    public String toJson(Movie movie) {
        JSONObject o = new JSONObject();
        o.put(TYPE, (Object)"playmovie");
        o.put(OBJECT, (Object)this.convert(movie));
        return o.toString();
    }

    public void process(String json) {
        this.log.debug((Object)("<< " + json));
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Wrong json: " + json);
        }
        try {
            String type;
            JSONObject obj = new JSONObject(json);
            switch (type = obj.getString(TYPE)) {
                case "playlist": {
                    this.notifyPlaylistDemand();
                    break;
                }
                case "start-play": {
                    this.notifyStartPlay(obj);
                    break;
                }
                case "finish-play": {
                    this.notifyFinishPlay(obj);
                    break;
                }
                case "log": {
                    this.notifyLog(obj);
                    break;
                }
                case "player-context-info": {
                    this.notifySystemInfo(obj);
                    break;
                }
                default: {
                    throw new JSONException("Unknown request type: " + type);
                }
            }
        }
        catch (JSONException ex) {
            this.log.error((Object)("Error on parse message: " + json), (Throwable)ex);
            this.notifyWrongMessage(json);
        }
    }

    private void notifySystemInfo(JSONObject o) {
        this.log.info((Object)"Process system info");
        JSONObject obj = o.getJSONObject(OBJECT);
        String appVer = obj.getString("app-version");
        this.log.info((Object)("    App-version: " + appVer));
        JSONObject jScreen = obj.getJSONObject("screen");
        Screen screen = new Screen(jScreen.getInt("width"), jScreen.getInt("height"), jScreen.getInt("color-depth"));
        this.log.info((Object)"    Screen:");
        this.log.info((Object)("         Width & height: " + screen.getWidth() + "x" + screen.getHeight()));
        this.log.info((Object)("         Color depth: " + screen.getColorDepth()));
        JSONObject jBrowserInfo = obj.getJSONObject("browser-info");
        String userAgent = jBrowserInfo.getString("name");
        this.log.info((Object)("    User-agent: " + userAgent));
        this.log.info((Object)"    Plugins:");
        JSONArray jPlugins = jBrowserInfo.getJSONArray("plugins");
        Plugin[] plugins = new Plugin[jPlugins.length()];
        for (int i = 0; i < jPlugins.length(); ++i) {
            JSONObject jPlugin = jPlugins.getJSONObject(i);
            String desc = jPlugin.getString("description");
            String filename = jPlugin.getString("filename");
            String name = jPlugin.getString("name");
            this.log.info((Object)("        Name: " + name));
            this.log.info((Object)("            Filename: " + filename));
            this.log.info((Object)("            Description: " + desc));
            this.log.info((Object)("            Mime-types: " + name));
            JSONArray jFormats = jPlugin.getJSONArray("mimeTypes");
            Format[] formats = new Format[jFormats.length()];
            for (int j = 0; j < jFormats.length(); ++j) {
                JSONObject jFormat = jFormats.getJSONObject(j);
                Format f = new Format(jFormat.getString(TYPE), jFormat.getString("suffixes"), jFormat.getString("description"));
                this.log.info((Object)("                Type: " + f.getType()));
                this.log.info((Object)("                Suffixes: " + f.getSuffixes()));
                this.log.info((Object)("                Description: " + f.getDescription()));
                formats[j] = f;
            }
            plugins[i] = new Plugin(name, desc, filename, formats);
        }
        SystemInfo systemInfo = new SystemInfo(screen, userAgent, appVer, plugins);
        this.log.info((Object)("Notify " + systemInfo));
        for (SystemListener pl : this.systemListeners) {
            pl.onSystemInfo(systemInfo);
        }
    }

    private void notifyLog(JSONObject o) {
        this.log.info((Object)"Process log record");
        for (SystemListener sl : this.systemListeners) {
            sl.onLog(o.getString("message"));
        }
    }

    private void notifyPlaylistDemand() {
        this.log.debug((Object)"Notify playlist demand");
        for (PlayerListener pl : this.playerListeners) {
            pl.onPlaylistDemand();
        }
    }

    private void notifyStartPlay(JSONObject o) {
        this.log.debug((Object)"Process start play");
        for (PlayerListener pl : this.playerListeners) {
            pl.onStartPlay(this.getMovie(o.getJSONObject(OBJECT)));
        }
    }

    private void notifyFinishPlay(JSONObject o) {
        this.log.debug((Object)"Process finish play");
        JSONObject res = o.getJSONObject(OBJECT);
        int result = res.getInt("result");
        int duration = res.getInt(DURATION);
        for (PlayerListener pl : this.playerListeners) {
            pl.onFinishPlay(this.getMovie(res.getJSONObject("movie")), result, duration);
        }
    }

    private void notifyWrongMessage(String json) {
        this.log.info((Object)"Notify wrong message");
        for (SystemListener pl : this.systemListeners) {
            pl.onWrongMessage(json);
        }
    }

    private JSONObject convert(Movie movie) {
        JSONObject mo = new JSONObject();
        mo.put(ID, movie.getId());
        mo.put(URL, (Object)movie.getFile().toURI().toString());
        mo.put(DURATION, movie.getDuration());
        return mo;
    }

    private Movie getMovie(JSONObject m) {
        String url = m.getString(URL).substring(5);
        url = url.indexOf(58) < 3 ? url.substring(1) : url;
        return new Movie(m.getInt(ID), new File(url), m.getInt(DURATION));
    }
}

