/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.player;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.disig.app.DiSigApplication;
import ru.softlogic.disig.player.DiSigPlayer;
import ru.softlogic.disig.player.JSonProcessor;
import ru.softlogic.disig.player.Movie;
import ru.softlogic.disig.player.PlayerException;
import ru.softlogic.disig.player.PlayerListener;
import ru.softlogic.disig.player.PlayerStatus;
import ru.softlogic.disig.player.Playlist;
import ru.softlogic.disig.player.SystemListener;

public abstract class BaseApplication
implements DiSigApplication,
DiSigPlayer {
    private final Set<PlayerListener> playerListeners = new HashSet<PlayerListener>();
    private final Set<SystemListener> systemListeners = new HashSet<SystemListener>();
    private final Logger log = Logger.getLogger(BaseApplication.class);
    private PlayerStatus playerStatus = PlayerStatus.New;
    private final JSonProcessor processor = new JSonProcessor(this.playerListeners, this.systemListeners);

    @Override
    public final DiSigPlayer getPlayer() {
        return this;
    }

    @Override
    public PlayerStatus getPlayerStatus() {
        return this.playerStatus;
    }

    @Override
    public void play(Playlist playlist) throws PlayerException {
        this.checkStatus();
        this.sendMessage(this.processor.toJson(playlist));
    }

    @Override
    public void play(Movie movie) throws PlayerException {
        this.checkStatus();
        this.sendMessage(this.processor.toJson(movie));
    }

    @Override
    public final void addPlayerListener(PlayerListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.playerListeners.add(listener);
    }

    @Override
    public final void addSystemListener(SystemListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.systemListeners.add(listener);
    }

    private void checkStatus() throws PlayerException {
        if (this.playerStatus != PlayerStatus.Connected) {
            throw new PlayerException("Wrong player status: " + (Object)((Object)this.playerStatus));
        }
    }

    protected final void notifyPlayerStatus(PlayerStatus playerStatus) {
        if (playerStatus != this.playerStatus) {
            this.playerStatus = playerStatus;
            this.log.info((Object)("Notify player status: " + (Object)((Object)playerStatus)));
            for (SystemListener sl : this.systemListeners) {
                sl.onChangeState(playerStatus);
            }
        }
    }

    protected final void onIncomingMessage(String message) {
        this.log.info((Object)("Incoming: " + message));
        this.processor.process(message);
    }

    protected abstract void sendMessage(String var1);
}

