/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.disig.impl.DirectoryOptions;
import ru.softlogic.disig.impl.MovieExtractor;
import ru.softlogic.disig.impl.Producer;
import ru.softlogic.disig.player.Movie;
import ru.softlogic.disig.player.Playlist;

public class StaticPlaylistProducer
implements Producer<Playlist> {
    private final File baseDir;
    private final Logger log = Logger.getLogger(StaticPlaylistProducer.class);

    public StaticPlaylistProducer(File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("BasePath is null");
        }
        this.baseDir = baseDir;
    }

    @Override
    public Playlist get() {
        this.log.debug((Object)"----------------------------------------------");
        this.log.debug((Object)("Try to build static list from path " + this.baseDir.getAbsolutePath()));
        LinkedList<Movie> movies = new LinkedList<Movie>();
        if (this.baseDir.isDirectory()) {
            int i = 0;
            for (File f : this.baseDir.listFiles(new DirFilter())) {
                this.log.debug((Object)("Process " + f.getAbsolutePath()));
                DirectoryOptions dro = new DirectoryOptions(f);
                if (dro.isDisabled()) {
                    this.log.debug((Object)"    Directory is disable, skip");
                    continue;
                }
                for (File mov : MovieExtractor.processDir(f)) {
                    this.log.info((Object)("    Add " + mov.getAbsolutePath()));
                    movies.add(new Movie(++i, mov, dro.getDuration() * 1000));
                }
            }
        }
        this.log.debug((Object)"--- Done");
        return new Playlist(movies);
    }

    public String toString() {
        return "StaticPlaylistProducer{}";
    }

    private class DirFilter
    implements FilenameFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return f.isDirectory();
        }
    }
}

