/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.impl;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import ru.softlogic.disig.impl.OptionsFilter;
import ru.softlogic.disig.utils.MediaDetector;

public class MovieExtractor {
    private MovieExtractor() {
    }

    public static List<File> processDir(File file) {
        LinkedList<File> res = new LinkedList<File>();
        if (file.isDirectory()) {
            File index = new File(file, "index.html");
            if (index.canRead() && index.length() > 0L) {
                res.add(index);
            } else {
                File[] nested = file.listFiles(new OptionsFilter());
                if (MovieExtractor.isContainOnlyMedia(MovieExtractor.getTypes(nested))) {
                    res.addAll(Arrays.asList(nested));
                }
            }
        }
        return res;
    }

    private static Set<MediaDetector.MediaType> getTypes(File[] file) {
        TreeSet<MediaDetector.MediaType> res = new TreeSet<MediaDetector.MediaType>();
        for (File f : file) {
            res.add(MediaDetector.getMediaType(f));
        }
        return res;
    }

    private static boolean isContainOnlyMedia(Set<MediaDetector.MediaType> set) {
        return !set.contains((Object)MediaDetector.MediaType.Unknown);
    }
}

