/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class DirectoryOptions {
    private static final String DATE_BEGIN = "begin";
    private static final String DATE_END = "end";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DISABLE = "disable";
    private final Properties prop;

    public DirectoryOptions(File dir) {
        this.prop = this.getProperties(dir);
    }

    public int getDuration() {
        String val = this.prop.getProperty("duration", "30");
        if (val.matches("\\d+")) {
            int res = Integer.parseInt(val);
            return res > 20 && res < 120 ? res : 30;
        }
        return 30;
    }

    public boolean isDisabled() {
        if ("true".equals(this.prop.getProperty(DISABLE))) {
            return true;
        }
        Date now = new Date();
        Date begin = DirectoryOptions.getDate(this.prop, DATE_BEGIN);
        Date end = DirectoryOptions.getDate(this.prop, DATE_END);
        if (begin != null && now.before(begin)) {
            return true;
        }
        return end != null && now.after(end);
    }

    private static Date getDate(Properties prop, String key) {
        String val = prop.getProperty(key);
        if (val != null && !val.isEmpty()) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            try {
                return sdf.parse(val);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Properties getProperties(File dir) {
        Properties res = new Properties();
        File opt = new File(dir, "options.properties");
        if (opt.canRead()) {
            try (FileInputStream is = new FileInputStream(opt);){
                res.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return res;
    }
}

