/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.impl;

import java.io.File;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.disig.impl.DirectoryOptions;
import ru.softlogic.disig.impl.MovieExtractor;
import ru.softlogic.disig.impl.Producer;
import ru.softlogic.disig.impl.StaticPlaylistProducer;
import ru.softlogic.disig.player.Movie;
import ru.softlogic.disig.player.Playlist;

public class DefaultPlaylistProducer
implements Producer<Playlist> {
    private File baseDir;
    private final Logger log = Logger.getLogger(StaticPlaylistProducer.class);

    public DefaultPlaylistProducer(File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("Dir is null");
        }
        this.baseDir = baseDir;
    }

    @Override
    public Playlist get() {
        this.log.debug((Object)"----------------------------------------------");
        this.log.debug((Object)("Try to build default list from path " + this.baseDir.getAbsolutePath()));
        LinkedList<Movie> movies = new LinkedList<Movie>();
        if (this.baseDir.isDirectory()) {
            int i = 0;
            DirectoryOptions dro = new DirectoryOptions(this.baseDir);
            for (File mov : MovieExtractor.processDir(this.baseDir)) {
                this.log.info((Object)("    Add " + mov.getAbsolutePath()));
                movies.add(new Movie(++i, mov, dro.getDuration() * 1000));
            }
        }
        this.log.debug((Object)"--- Done");
        return new Playlist(movies);
    }

    public String toString() {
        return "DefaultPlaylistProducer{}";
    }
}

