/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.impl;

import org.apache.log4j.Logger;
import ru.softlogic.disig.impl.Producer;
import ru.softlogic.disig.player.DiSigPlayer;
import ru.softlogic.disig.player.Movie;
import ru.softlogic.disig.player.PlayerException;
import ru.softlogic.disig.player.PlayerListener;
import ru.softlogic.disig.player.Playlist;

public class DefaultPlayerListener
implements PlayerListener {
    private final DiSigPlayer player;
    private final Producer<Playlist> producer;
    private final Logger log = Logger.getLogger(DefaultPlayerListener.class);

    public DefaultPlayerListener(DiSigPlayer player, Producer<Playlist> producer) {
        if (player == null) {
            throw new NullPointerException("DiSigPlayer is null");
        }
        if (producer == null) {
            throw new NullPointerException("Producer is null");
        }
        this.player = player;
        this.producer = producer;
    }

    @Override
    public void onPlaylistDemand() {
        this.log.debug((Object)"Playlist requested, build playlist");
        Playlist pl = this.producer.get();
        this.log.debug((Object)("Result: " + pl));
        try {
            this.log.debug((Object)"Sent it to player");
            this.player.play(pl);
            this.log.debug((Object)"Done");
        }
        catch (PlayerException ex) {
            this.log.error((Object)"Error on play", (Throwable)ex);
        }
    }

    @Override
    public void onStartPlay(Movie movie) {
        this.log.info((Object)("Start play movie " + movie));
    }

    @Override
    public void onFinishPlay(Movie movie, int result, int duration) {
        this.log.info((Object)("Finish play " + movie + ", result=" + result + ", duration=" + duration));
    }
}

