/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import ru.softlogic.disig.app.DiSigApplication;
import ru.softlogic.disig.app.DiSigCreatingException;
import ru.softlogic.disig.player.netty.NettyApplication;
import ru.softlogic.disig.utils.IOUtils;

public class DiSigFactory {
    public static final String WEBSOCKET_PATH = "/softlogicds";
    private static final String CONFIG = "config.properties";

    private DiSigFactory() {
    }

    public static DiSigApplication createApp(File cfgDir) throws DiSigCreatingException {
        File cfg = new File(cfgDir, CONFIG);
        Properties prop = new Properties(DiSigFactory.getDefProperties());
        if (cfg.canRead()) {
            try (FileInputStream is = new FileInputStream(cfg);){
                prop.load(is);
            }
            catch (IOException ex) {
                throw new DiSigCreatingException("Error on read config " + cfg, ex);
            }
        }
        return new NettyApplication(DiSigFactory.getPortNumber(prop), WEBSOCKET_PATH);
    }

    private static Properties getDefProperties() throws DiSigCreatingException {
        Properties def = new Properties();
        InputStream is = DiSigFactory.class.getResourceAsStream(CONFIG);
        if (is != null) {
            try {
                def.load(is);
            }
            catch (IOException ex) {
                throw new DiSigCreatingException("Error on load default config", ex);
            }
            finally {
                IOUtils.close(is);
            }
        } else {
            throw new DiSigCreatingException("Default config is not found");
        }
        return def;
    }

    private static int getPortNumber(Properties prop) throws DiSigCreatingException {
        String port = prop.getProperty("port");
        if (!port.matches("\\d{4,5}")) {
            throw new DiSigCreatingException("Wrong port format: " + port);
        }
        int p = Integer.parseInt(port);
        if (p < 1000 || p > 65000) {
            throw new DiSigCreatingException("Port number must be in range 1000..65000");
        }
        return p;
    }
}

