/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.disig;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import ru.softlogic.disig.ErrorHandler;
import ru.softlogic.disig.app.DiSigAppException;
import ru.softlogic.disig.app.DiSigApplication;
import ru.softlogic.disig.app.DiSigCreatingException;
import ru.softlogic.disig.app.DiSigFactory;
import ru.softlogic.disig.impl.CascadeProducer;
import ru.softlogic.disig.impl.DefaultPlayerListener;
import ru.softlogic.disig.impl.DefaultPlaylistProducer;
import ru.softlogic.disig.impl.StaticPlaylistProducer;

public class Main {
    private Main() {
    }

    public static void main(String[] args) {
        String appDir = System.getProperty("app.dir");
        if (appDir == null || appDir.isEmpty()) {
            System.out.println("To run the application: java -Dapp.dir=<home-dir> -jar disig.jar");
            return;
        }
        File hd = new File(appDir);
        if (!hd.isDirectory()) {
            System.out.println("Home directory '" + appDir + "' must exist");
            return;
        }
        PropertyConfigurator.configure((URL)Main.class.getResource("log4j.properties"));
        Logger log = Logger.getLogger(Main.class);
        Thread.setDefaultUncaughtExceptionHandler(new ErrorHandler());
        try {
            Main.checkSubDir(hd, "log");
            log.info((Object)"Try to launch app");
            DiSigApplication app = DiSigFactory.createApp(hd);
            DefaultPlayerListener dpl = new DefaultPlayerListener(app.getPlayer(), new CascadeProducer(new StaticPlaylistProducer(new File(hd, "content/static/")), new DefaultPlaylistProducer(new File(hd, "content/default/"))));
            app.getPlayer().addPlayerListener(dpl);
            app.start();
            log.info((Object)"Successfully launched");
        }
        catch (DiSigAppException | DiSigCreatingException ex) {
            log.error((Object)"Error on start application", (Throwable)ex);
        }
    }

    private static void checkSubDir(File home, String subDir) throws DiSigCreatingException {
        File sd = new File(home, subDir);
        if (!sd.isDirectory() && !sd.mkdirs()) {
            throw new DiSigCreatingException("Can't create dir " + sd.getAbsolutePath());
        }
    }
}

