/*
 * Decompiled with CFR 0.152.
 */
package fxterm.utils;

import fxterm.app.id.LoggerId;
import fxterm.module.Pack;
import fxterm.session.Change;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;
import ru.softlogic.srv.queue.utils.ObjectReadWriteStream;
import ru.softlogic.system.util.PathUtils;

public class SaveUtils {
    private static final Logger log = LoggerId.PAY;

    public static Change loadChange() {
        Change change = null;
        ObjectReadWriteStream changeSave = null;
        try {
            log.info((Object)"Uploading change from disk");
            changeSave = new ObjectReadWriteStream(PathUtils.getPath((String)"/data/save/change.obj"));
            change = (Change)changeSave.readObject();
            changeSave.close();
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"Change file not found: ", (Throwable)e);
        }
        catch (Exception ex) {
            log.error((Object)"Error of change loading", (Throwable)ex);
        }
        finally {
            if (changeSave != null) {
                try {
                    changeSave.close();
                }
                catch (IOException e) {}
            }
        }
        return change;
    }

    public static void saveChange(Change change) {
        ObjectReadWriteStream changeSave = null;
        try {
            log.info((Object)("Save change to disk: " + change));
            changeSave = new ObjectReadWriteStream(PathUtils.getPath((String)"/data/save/change.obj"));
            changeSave.writeObject((Serializable)change);
            changeSave.close();
        }
        catch (IOException | ClassCastException ex) {
            log.error((Object)"Error of change saving: ", (Throwable)ex);
        }
        finally {
            if (changeSave != null) {
                try {
                    changeSave.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteChange() {
        try {
            File chf = new File(PathUtils.getPath((String)"/data/save/change.obj"));
            if (chf.exists()) {
                log.info((Object)("Delete change from disk: " + chf.delete()));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error of change deleting: ", (Throwable)ex);
        }
    }

    public static Pack loadPack() {
        ObjectReadWriteStream packSave = null;
        Pack pack = null;
        try {
            log.info((Object)"Uploading pack from disk");
            packSave = new ObjectReadWriteStream(PathUtils.getPath((String)"/data/save/pack.obj"));
            pack = (Pack)packSave.readObject();
            packSave.close();
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"Pack file not found:", (Throwable)e);
        }
        catch (Exception ex) {
            log.error((Object)"Error of pack loading: ", (Throwable)ex);
        }
        finally {
            if (packSave != null) {
                try {
                    packSave.close();
                }
                catch (IOException e) {}
            }
        }
        return pack;
    }

    public static void savePack(Pack pack) {
        ObjectReadWriteStream packSave = null;
        try {
            log.info((Object)("Save pack to disk: " + pack));
            packSave = new ObjectReadWriteStream(PathUtils.getPath((String)"/data/save/pack.obj"));
            packSave.writeObject((Serializable)pack);
            packSave.close();
        }
        catch (IOException | ClassCastException ex) {
            log.error((Object)"Error of pack saving: ", (Throwable)ex);
        }
        finally {
            if (packSave != null) {
                try {
                    packSave.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deletePack() {
        try {
            File pkgf = new File(PathUtils.getPath((String)"/data/save/pack.obj"));
            if (pkgf.exists()) {
                log.info((Object)("Delete pack from disk:  " + pkgf.delete()));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error of pack deleting: ", (Throwable)ex);
        }
    }
}

