/*
 * Decompiled with CFR 0.152.
 */
package fxterm.utils;

import fxterm.session.Session;
import java.net.URL;
import java.util.List;
import java.util.Map;
import plfx.util.Locator;
import ru.softlogic.reference.References;
import ru.softlogic.reference.geo.Country;
import ru.softlogic.reference.geo.GeographicArea;
import ru.softlogic.reference.geo.GeographicLocale;

public class GeoUtils {
    private GeoUtils() {
    }

    public static GeographicArea getGeographicAreaById(Integer id) {
        if (id == null) {
            GeographicArea result = new GeographicArea();
            result.setIcon(GeoUtils.noImage());
            return result;
        }
        List gas = References.getGeographicAreas();
        if (gas != null) {
            for (GeographicArea ga : gas) {
                if (ga.getId() != id.intValue()) continue;
                GeographicArea result = new GeographicArea(ga);
                if (result.getIcon() != null && !result.getIcon().isEmpty()) {
                    URL path = Locator.getFileUrl((String)("/gui/skin/{name}/img/" + result.getIcon()));
                    if (path != null) {
                        result.setIcon(GeoUtils.cssImage(path));
                    } else {
                        result.setIcon(null);
                    }
                }
                if (ga.getLocales() != null) {
                    for (Map.Entry locale : ga.getLocales().entrySet()) {
                        if (!((String)locale.getKey()).equalsIgnoreCase(Session.getLocale().getLanguage())) continue;
                        result.setName(((GeographicLocale)locale.getValue()).getName());
                        result.setShortName(((GeographicLocale)locale.getValue()).getShortName());
                        break;
                    }
                }
                return result;
            }
        }
        return null;
    }

    public static Country getCountryById(Integer id) {
        if (id == null) {
            Country result = new Country();
            result.setIcon(GeoUtils.noImage());
            return result;
        }
        List gas = References.getGeographicAreas();
        if (gas != null) {
            for (GeographicArea ga : gas) {
                if (ga.getCountries() == null) continue;
                for (Country c : ga.getCountries()) {
                    if (c.getId() != id.intValue()) continue;
                    Country result = new Country(c.getId(), c.getName(), c.isUseKladr(), c.isDefaultCountry(), c.getFullName(), c.getCode(), c.getIdGeographicArea(), c.getIcon(), c.getShortName(), c.getLocales());
                    if (result.getIcon() != null && !result.getIcon().isEmpty()) {
                        URL path = Locator.getFileUrl((String)("/gui/skin/{name}/img/" + result.getIcon()));
                        if (path != null) {
                            result.setIcon(GeoUtils.cssImage(path));
                        } else {
                            result.setIcon(null);
                        }
                    }
                    if (c.getLocales() != null) {
                        for (Map.Entry locale : c.getLocales().entrySet()) {
                            if (!((String)locale.getKey()).equalsIgnoreCase(Session.getLocale().getLanguage())) continue;
                            result.setName(((GeographicLocale)locale.getValue()).getName());
                            result.setShortName(((GeographicLocale)locale.getValue()).getShortName());
                            result.setFullName(((GeographicLocale)locale.getValue()).getFullName());
                            break;
                        }
                    }
                    return result;
                }
            }
        }
        return null;
    }

    private static String cssImage(URL path) {
        return "-fx-background-image: url('" + path.toString() + "');";
    }

    private static String noImage() {
        return "-fx-background-image: none;";
    }
}

