/*
 * Decompiled with CFR 0.152.
 */
package fxterm.utils;

import fxterm.app.id.LoggerId;
import fxterm.utils.CRWrap;
import fxterm.utils.RateComparator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import ru.softlogic.hardware.currency.CurrencyHelper;
import ru.softlogic.reference.References;
import ru.softlogic.reference.currency.CurrencyPair;
import ru.softlogic.reference.currency.CurrencyRate;

public class FxHelper {
    private static final double E = 1.0E-8;

    private FxHelper() {
    }

    public static CurrencyRate getRate(String currency) {
        LinkedList<Object> filtered = new LinkedList<Object>();
        Object[] crs = References.getCurrencyRates();
        LoggerId.PAY.info((Object)("nf=" + Arrays.toString(crs)));
        Date now = new Date();
        if (crs != null) {
            for (Object cr : crs) {
                if (!currency.equals(cr.getCurrency()) || cr.getFrom().compareTo(now) > 0) continue;
                filtered.add(cr);
            }
        }
        LoggerId.PAY.info((Object)("filtered=" + filtered));
        if (filtered.isEmpty()) {
            return null;
        }
        if (filtered.size() != 1) {
            Collections.sort(filtered, new RateComparator());
        }
        return (CurrencyRate)filtered.get(0);
    }

    public static CRWrap getRate(Short srvId, String fromCurr, String toCurr, boolean calcReverce) {
        CurrencyRate cr = FxHelper.getRate(srvId, fromCurr, toCurr);
        if (cr != null || !calcReverce) {
            return new CRWrap(cr, false);
        }
        cr = FxHelper.getRate(srvId, toCurr, fromCurr);
        if (cr != null) {
            return new CRWrap(cr, true);
        }
        return null;
    }

    public static CurrencyRate getRate(Short srvId, String fromCurr, String toCurr) {
        CurrencyHelper.checkCurrency((String)fromCurr);
        CurrencyHelper.checkCurrency((String)toCurr);
        if (fromCurr.equals(toCurr)) {
            return new CurrencyRate(new Date(), fromCurr, toCurr, 1, 1.0, new CurrencyPair(fromCurr, toCurr), 1.0);
        }
        LinkedList<CurrencyRate> filtered = new LinkedList<CurrencyRate>();
        CurrencyRate[] crs = References.getCurrencyRates();
        Date now = new Date();
        if (crs == null) {
            return null;
        }
        if (srvId != null) {
            for (CurrencyRate cr : crs) {
                if (!srvId.equals(cr.getServiceId()) || cr.getCurrencyPair() == null || !(cr.getBid() > 1.0E-8) || !fromCurr.equals(cr.getCurrencyPair().getBaseCurrency()) || !toCurr.equals(cr.getCurrencyPair().getCurrency()) || cr.getFrom().compareTo(now) > 0) continue;
                filtered.add(cr);
            }
        }
        if (filtered.isEmpty()) {
            for (CurrencyRate cr : crs) {
                if (cr.getCurrencyPair() == null || !(cr.getBid() > 1.0E-8) || !fromCurr.equals(cr.getCurrencyPair().getBaseCurrency()) || !toCurr.equals(cr.getCurrencyPair().getCurrency()) || cr.getFrom().compareTo(now) > 0) continue;
                filtered.add(cr);
            }
        }
        if (filtered.isEmpty()) {
            return null;
        }
        if (filtered.size() != 1) {
            Collections.sort(filtered, new RateComparator());
        }
        return (CurrencyRate)filtered.get(0);
    }
}

