/*
 * Decompiled with CFR 0.152.
 */
package fxterm.utils;

import fxterm.app.FxEnv;
import fxterm.core.hdw.bvr.oper.CashSet;
import fxterm.core.hdw.bvr.oper.IssuedCashBackCard;
import fxterm.session.Session;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.system.util.PinCodeGenerator;

public class FinUtils {
    private static final Map<Integer, Integer> CASH_CONVERTION_MAP = new HashMap<Integer, Integer>();

    public static Sum calculate(Map<CashUnit, Integer> set, String curr) {
        int sum = 0;
        for (Map.Entry<CashUnit, Integer> e : set.entrySet()) {
            if (!e.getKey().getNominal().getCurrency().equals(curr)) continue;
            int count = e.getValue();
            sum += count * e.getKey().getNominal().getValue();
        }
        return new Sum(sum, curr);
    }

    public static Sum createVoidSum() {
        return new Sum(0, Session.getInCurrency());
    }

    public static SumResult createFullChange(Sum change) {
        Sum s0 = new Sum(0, change.getCurrency());
        return new SumResult(s0, s0, s0, s0, s0, change, null);
    }

    public static IssuedCashBackCard generate(Sum nominal) {
        return new IssuedCashBackCard(PinCodeGenerator.generate(), nominal);
    }

    public static CashSet createCashSet(Map<CashUnit, Integer> set) {
        return new CashSet(Session.getInCurrency(), set);
    }

    public static void add(Keeper keeper, Sum sum) {
        keeper.addPayback(sum);
    }

    public static CashUnit converte(Denomination d) {
        return new CashUnit(d.getId(), new Sum(d.getNominal(), d.getCurrency()), CASH_CONVERTION_MAP.get(d.getType()).intValue());
    }

    public static Set<CashUnit> convert(Set<Denomination> ds) {
        TreeSet<CashUnit> cus = new TreeSet<CashUnit>();
        ds.stream().forEach(d -> cus.add(FinUtils.converte(d)));
        return cus;
    }

    public static String getFeHash() {
        DeviceInfo lastInfo;
        StringBuilder sb = new StringBuilder();
        if (FxEnv.getBillValidator() != null && (lastInfo = FxEnv.getBillValidator().getLastInfo()) != null) {
            sb.append(lastInfo.getVendor());
            sb.append(lastInfo.getModel());
            sb.append(lastInfo.getSerial());
            sb.append(lastInfo.getPort());
            sb.append(lastInfo.getProto());
        }
        if (FxEnv.getCoinValidator() != null && (lastInfo = FxEnv.getCoinValidator().getLastInfo()) != null) {
            sb.append(lastInfo.getVendor());
            sb.append(lastInfo.getModel());
            sb.append(lastInfo.getSerial());
            sb.append(lastInfo.getPort());
            sb.append(lastInfo.getProto());
        }
        try {
            return FinUtils.getBase64(FinUtils.getSHA256(sb.toString()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static byte[] getSHA256(String source) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.reset();
        md.update(source.getBytes());
        return md.digest();
    }

    private static String getBase64(byte[] source) {
        return new String(Base64.encodeBase64((byte[])source));
    }

    public static int calculate(Box box, String curr) {
        int sum = 0;
        for (Map.Entry e : box.getCounts().entrySet()) {
            if (!((Denomination)e.getKey()).getCurrency().equals(curr)) continue;
            sum += ((Denomination)e.getKey()).getNominal() * (Integer)e.getValue();
        }
        return sum;
    }

    public static Map<String, Integer> getTotalBoxSum(Box box) {
        HashMap<String, Integer> sumMap = new HashMap<String, Integer>();
        for (Map.Entry entry : box.getCounts().entrySet()) {
            Denomination key = (Denomination)entry.getKey();
            int sum = sumMap.getOrDefault(key.getCurrency(), 0);
            sumMap.put(key.getCurrency(), sum += key.getNominal() * (Integer)entry.getValue());
        }
        return sumMap;
    }

    static {
        CASH_CONVERTION_MAP.put(0, 3);
        CASH_CONVERTION_MAP.put(1, 4);
    }
}

