/*
 * Decompiled with CFR 0.152.
 */
package fxterm.utils;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.cash.BoxId;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hdw.dev.cashdisp.OperationDispenseResult;
import ru.softlogic.reference.hdw.PayoutProfile;

public final class CompatUtils {
    private CompatUtils() {
    }

    public static ru.softlogic.cash.Sum convert(Sum sum) {
        return new ru.softlogic.cash.Sum(sum.getValue(), sum.getCurrency());
    }

    public static Sum convert(ru.softlogic.cash.Sum sum) {
        return new Sum(sum.getValue(), sum.getCurrency());
    }

    public static ru.softlogic.cash.Sum convertNull(Sum sum) {
        if (sum == null) {
            return null;
        }
        return new ru.softlogic.cash.Sum(sum.getValue(), sum.getCurrency());
    }

    public static Sum convertNull(ru.softlogic.cash.Sum sum) {
        if (sum == null) {
            return null;
        }
        return new Sum(sum.getValue(), sum.getCurrency());
    }

    public static CashUnit convert(Denomination d) {
        if (d == null) {
            throw new NullPointerException("Denomination is null");
        }
        CashUnit cu = new CashUnit(d.getId(), new ru.softlogic.cash.Sum(d.getNominal(), d.getCurrency()), d.getType() == 1 ? 4 : 3);
        return cu;
    }

    public static Denomination convert(CashUnit cashUnit) {
        if (cashUnit == null) {
            throw new NullPointerException("CashUnit is null");
        }
        return new Denomination(cashUnit.getId(), cashUnit.getType() == 4 ? 1 : 0, cashUnit.getNominal().getValue(), cashUnit.getNominal().getCurrency());
    }

    public static Keeper convert(BoxId boxId, Map<Denomination, Integer> set) {
        Keeper k = new Keeper();
        for (Map.Entry<Denomination, Integer> e : set.entrySet()) {
            k.addCash(boxId, CompatUtils.convert(e.getKey()), e.getValue().intValue());
        }
        return k;
    }

    public static Map<CashUnit, Integer> convertToMap(Map<Denomination, Integer> set) {
        HashMap<CashUnit, Integer> res = new HashMap<CashUnit, Integer>();
        for (Map.Entry<Denomination, Integer> e : set.entrySet()) {
            res.put(CompatUtils.convert(e.getKey()), e.getValue());
        }
        return res;
    }

    public static BoxId convertBoxId(ru.softlogic.storage.cash.BoxId hwdBoxId) {
        if (hwdBoxId == null) {
            return null;
        }
        return new BoxId(hwdBoxId.getDeviceClass(), hwdBoxId.getDeviceNumber(), hwdBoxId.getBoxNumber());
    }

    public static Map<CashUnit, Integer> convertToMap(OperationDispenseResult result) {
        return CompatUtils.convertToMap(result.getTotals().getCounts());
    }

    public static ru.softlogic.hdw.dev.cashacc.PayoutProfile convertPayoutProfile(PayoutProfile profile) {
        if (profile == null) {
            return null;
        }
        return new ru.softlogic.hdw.dev.cashacc.PayoutProfile("", "", CompatUtils.convertCashUnitMap(profile.getCounts()));
    }

    public static Map<Denomination, Integer> convertCashUnitMap(Map<CashUnit, Integer> cashUnitMap) {
        HashMap<Denomination, Integer> result = new HashMap<Denomination, Integer>();
        for (Map.Entry<CashUnit, Integer> entry : cashUnitMap.entrySet()) {
            CashUnit unit = entry.getKey();
            Denomination denomination = new Denomination(unit.getId(), unit.getType() == 4 ? 1 : 0, unit.getNominal().getValue(), unit.getNominal().getCurrency());
            result.put(denomination, entry.getValue());
        }
        return result;
    }
}

